package pangea.hiagent.websocket;

import org.junit.jupiter.api.Test;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.WebSocketSession;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import static org.mockito.Mockito.*;

public class BinaryMessageSenderTest {

    @Test
    public void testSendLargeBinaryMessage() throws Exception {
        // 创建模拟的WebSocket连接管理器
        WebSocketConnectionManager connectionManager = mock(WebSocketConnectionManager.class);
        
        // 创建BinaryMessageSender实例
        BinaryMessageSender sender = new BinaryMessageSender(connectionManager);
        
        // 创建一个大型消息（模拟797835字节的消息）
        StringBuilder largeMessageBuilder = new StringBuilder();
        for (int i = 0; i < 800000; i++) {
            largeMessageBuilder.append("A");
        }
        String largeMessage = largeMessageBuilder.toString();
        
        // 发送大型消息
        sender.sendBinaryMessage(largeMessage);
        
        // 等待一段时间让异步任务完成
        Thread.sleep(5000);
        
        // 验证连接管理器的broadcastMessage方法被调用
        verify(connectionManager, atLeastOnce()).broadcastMessage(any(BinaryMessage.class), eq(sender));
        
        // 销毁sender以清理资源
        sender.destroy();
    }
}