package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * User实体类
 * 代表系统用户
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("sys_user")
public class User extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 用户名
     */
    private String username;
    
    /**
     * 密码（加密存储）
     */
    private String password;
    
    /**
     * 邮箱
     */
    private String email;
    
    /**
     * 昵称
     */
    private String nickname;
    
    /**
     * 用户状态（active/inactive/banned）
     */
    private String status;
    
    /**
     * 用户角色（admin/user/api_user）
     */
    private String role;
    
    /**
     * 头像
     */
    private String avatar;
    
    /**
     * 最后登录时间
     */
    private Long lastLoginTime;
    
    /**
     * API Key
     */
    private String apiKey;
}
