package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 工具配置实体类
 * 用于存储工具参数配置
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("tool_configs")
public class ToolConfig extends BaseEntity {
    
    /**
     * 工具名称
     */
    @TableField("tool_name")
    private String toolName;
    
    /**
     * 参数名称
     */
    @TableField("param_name")
    private String paramName;
    
    /**
     * 参数值
     */
    @TableField("param_value")
    private String paramValue;
    
    /**
     * 参数描述
     */
    private String description;
    
    /**
     * 默认值
     */
    @TableField("default_value")
    private String defaultValue;
    
    /**
     * 参数类型
     */
    private String type;
    
    /**
     * 是否必填
     */
    private Boolean required;
    
    /**
     * 参数分组
     */
    @TableField("group_name")
    private String groupName;
}