package pangea.hiagent.web.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import jakarta.validation.constraints.NotBlank;

/**
 * 聊天请求DTO
 * 用于处理前端发送的聊天请求
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ChatRequest {
    @NotBlank(message = "用户消息不能为空")
    private String message;
    
    /**
     * 将ChatRequest转换为AgentRequest
     * 
     * @param agentId Agent ID
     * @param agent Agent对象，包含模型配置等信息
     * @param agentToolManager Agent工具管理器
     * @return AgentRequest对象
     */
    public AgentRequest toAgentRequest(String agentId, pangea.hiagent.model.Agent agent, pangea.hiagent.tool.AgentToolManager agentToolManager) {
        return AgentRequest.builder()
                .agentId(agentId)
                .systemPrompt(agent.getSystemPrompt())
                .userMessage(this.message)
                .model(agent.getDefaultModel())
                .temperature(agent.getTemperature())
                .maxTokens(agent.getMaxTokens())
                .topP(agent.getTopP())
                .streaming(agent.getEnableStreaming())
                .tools(agentToolManager.getToolNames(agent))
                .build();
    }
}