package pangea.hiagent.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 工作面板事件数据传输对象
 * 用于在SSE流中传输工作面板的各类事件（思考过程、工具调用等）
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WorkPanelEvent implements Serializable {
    private static final long serialVersionUID = 1L;
    
    /**
     * 事件类型：thinking/tool_call/tool_result/tool_error/log/embed
     */
    private String eventType;
    
    /**
     * 事件发生的时间戳
     */
    private Long timestamp;
    
    /**
     * 对于thinking事件：思考内容
     * 对于tool_call事件：工具调用详情
     * 对于log事件：日志内容
     */
    private String content;
    
    /**
     * 思考类型（分析、规划、执行等）
     */
    private String thinkingType;
    
    /**
     * 工具名称
     */
    private String toolName;
    
    /**
     * 工具执行的方法/action
     */
    private String toolAction;
    
    /**
     * 工具输入参数
     */
    private Map<String, Object> toolInput;
    
    /**
     * 工具输出结果
     */
    private Object toolOutput;
    
    /**
     * 工具执行状态（pending/success/failure）
     */
    private String toolStatus;
    
    /**
     * 日志级别（info/warn/error/debug）
     */
    private String logLevel;
    
    /**
     * 执行耗时（毫秒）
     */
    private Long executionTime;
    
    /**
     * Embed事件信息 - 嵌入资源URL
     */
    private String embedUrl;
    
    /**
     * Embed事件信息 - MIME类型
     */
    private String embedType;
    
    /**
     * Embed事件信息 - 嵌入事件标题
     */
    private String embedTitle;
    
    /**
     * Embed事件信息 - HTML内容
     */
    private String embedHtmlContent;
    
    /**
     * 附加数据
     */
    private Map<String, Object> metadata;
}