/*
 * @Description: 表单页store
 * @Author: gaorubin
 * @Date: 2025-12-24 16:12:58
 * @LastEditors: gaorubin
 * @LastEditTime: 2025-12-24 17:26:54
 */
import { defineStore } from "pinia";
import { cloneDeep } from "lodash-es";

// 初始页面json外层
const INIT_FORM_JSON = {
  pages: [
    {
      key: 0,
      type: "default",
      name: "默认页",
      code: "",
      display: "",
      props: {
        margin: "16px",
        padding: "12px",
        backgroundColor: "white",
        display: {},
      },
      bindProps: {},
      coms: [
        {
          key: 1,
          type: "node",
          name: "表单容器",
          code: "HiFormContainer",
          display: "",
          props: {
            status: "default",
            backgroundColor: "transparent",
            layout: "horizontal",
            size: "medium",
            labelAlign: "right",
            display: {},
            borderRadius: {},
            boxShadow: {},
            loop: {
              data: [],
            },
          },
          bindProps: {},
          coms: [],
        },
      ],
    },
  ],
  params: [],
  apis: [],
  funcs: [],
  pageTemplate: {},
};

export const useFormStore = defineStore("form", {
  state: () => ({
    // 表单 JSON 配置（使用深拷贝避免共享引用）
    formJson: cloneDeep(INIT_FORM_JSON),

    // 是否显示表单页面
    showForm: false,
  }),

  actions: {
    /**
     * 设置表单 JSON 配置
     * @param json 表单配置对象
     */
    setFormJson(json: any) {
      this.formJson = json;
    },

    /**
     * 清空表单 JSON 配置
     */
    clearFormJson() {
      this.formJson = cloneDeep(INIT_FORM_JSON);
    },

    /**
     * 显示表单页面
     * @param json 可选的表单配置对象，格式为 { coms: [] }
     */
    openForm(json?: any) {
      if (json) {
        // 验证 json 的有效性
        if (!json.coms || !Array.isArray(json.coms)) {
          console.error("无效的表单配置：缺少 coms 数组", json);
          return;
        }

        // 深拷贝 INIT_FORM_JSON 避免修改原始对象
        const formConfig = cloneDeep(INIT_FORM_JSON);

        // 将接收到的 coms 放入表单容器的 coms 数组中
        // 表单容器位于 pages[0].coms[0]（HiFormContainer）
        if (
          formConfig.pages &&
          formConfig.pages[0] &&
          formConfig.pages[0].coms &&
          formConfig.pages[0].coms[0]
        ) {
          formConfig.pages[0].coms[0].coms = json.coms;
        } else {
          console.error("INIT_FORM_JSON 结构异常，无法找到表单容器");
          return;
        }

        // 设置表单配置
        this.setFormJson(formConfig);

        this.showForm = true;
      }
    },

    /**
     * 隐藏表单页面
     */
    closeForm() {
      this.showForm = false;
      this.clearFormJson();
    },
  },
});
