package pangea.hiagent.repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import pangea.hiagent.model.Tool;

import java.util.List;

/**
 * 工具仓库接口
 * 提供工具数据访问功能
 */
@Mapper
public interface ToolRepository extends BaseMapper<Tool> {
    
    /**
     * 根据所有者获取工具列表
     * @param owner 所有者ID
     * @return 工具列表
     */
    @Select("SELECT * FROM tool WHERE owner = #{owner} AND deleted = 0 ORDER BY created_at DESC")
    List<Tool> findByOwner(String owner);
    
    /**
     * 根据所有者和状态获取工具列表
     * @param owner 所有者ID
     * @param status 工具状态
     * @return 工具列表
     */
    @Select("SELECT * FROM tool WHERE owner = #{owner} AND status = #{status} AND deleted = 0 ORDER BY created_at DESC")
    List<Tool> findByOwnerAndStatus(String owner, String status);
    
    /**
     * 根据名称和所有者获取工具
     * @param name 工具名称
     * @param owner 所有者ID
     * @return 工具对象
     */
    @Select("SELECT * FROM tool WHERE name = #{name} AND owner = #{owner} AND deleted = 0 LIMIT 1")
    Tool findByNameAndOwner(String name, String owner);
}