package pangea.hiagent.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 工作面板状态数据传输对象
 * 用于API返回工作面板的当前状态
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WorkPanelStatusDto implements Serializable {
    private static final long serialVersionUID = 1L;
    
    /**
     * 工作面板ID
     */
    private String id;
    
    /**
     * 当前Agent ID
     */
    private String agentId;
    
    /**
     * 当前Agent名称
     */
    private String agentName;
    
    /**
     * 所有事件列表
     */
    private List<WorkPanelEvent> events;
    
    /**
     * 思考过程事件列表
     */
    private List<WorkPanelEvent> thinkingEvents;
    
    /**
     * 工具调用事件列表
     */
    private List<WorkPanelEvent> toolCallEvents;
    
    /**
     * 执行日志事件列表
     */
    private List<WorkPanelEvent> logEvents;
    
    /**
     * 总事件数量
     */
    private Integer totalEvents;
    
    /**
     * 成功的工具调用数
     */
    private Integer successfulToolCalls;
    
    /**
     * 失败的工具调用数
     */
    private Integer failedToolCalls;
    
    /**
     * 更新时间戳
     */
    private Long updateTimestamp;
    
    /**
     * 是否正在处理中
     */
    private Boolean isProcessing;
}
