package pangea.hiagent.model;

/**
 * 认证模式枚举
 * 定义系统支持的各种身份认证方式
 */
public enum AuthMode {
    /**
     * 本地用户名/密码认证
     */
    LOCAL("local", "本地用户认证"),
    
    /**
     * OAuth2.0 授权码模式
     */
    OAUTH2_AUTHORIZATION_CODE("oauth2_auth_code", "OAuth2.0 授权码模式"),
    
    /**
     * OAuth2.0 隐式授权
     */
    OAUTH2_IMPLICIT("oauth2_implicit", "OAuth2.0 隐式授权"),
    
    /**
     * OAuth2.0 客户端凭证
     */
    OAUTH2_CLIENT_CREDENTIALS("oauth2_client_credentials", "OAuth2.0 客户端凭证"),
    
    /**
     * LDAP 目录认证
     */
    LDAP("ldap", "LDAP 目录认证"),
    
    /**
     * SAML 单点登录
     */
    SAML("saml", "SAML 单点登录");
    
    private final String code;
    private final String description;
    
    AuthMode(String code, String description) {
        this.code = code;
        this.description = description;
    }
    
    public String getCode() {
        return code;
    }
    
    public String getDescription() {
        return description;
    }
    
    /**
     * 根据代码获取认证模式
     */
    public static AuthMode fromCode(String code) {
        for (AuthMode mode : AuthMode.values()) {
            if (mode.code.equals(code)) {
                return mode;
            }
        }
        return null;
    }
}
