package pangea.hiagent.common.config;

import org.quartz.Scheduler;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

/**
 * Quartz配置类
 * 配置Quartz调度器和相关组件
 */
@Configuration
public class QuartzConfig {

    /**
     * 配置JobFactory，用于将Spring的Bean注入到Quartz的Job中
     */
    @Bean
    public JobFactory jobFactory() {
        SpringBeanJobFactory jobFactory = new SpringBeanJobFactory();
        return jobFactory;
    }

    /**
     * 配置SchedulerFactoryBean，用于创建Scheduler实例
     */
    @Bean
    public SchedulerFactoryBean schedulerFactoryBean(@Autowired JobFactory jobFactory) {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setJobFactory(jobFactory);
        factory.setWaitForJobsToCompleteOnShutdown(true);
        factory.setOverwriteExistingJobs(true);
        return factory;
    }

    /**
     * 配置Scheduler实例，用于管理和执行定时任务
     */
    @Bean
    public Scheduler scheduler(@Autowired SchedulerFactoryBean factory) {
        return factory.getScheduler();
    }
}
