package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * AgentDialogue实体类
 * 代表Agent的一条对话记录
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("agent_dialogue")
public class AgentDialogue extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 关联的Agent ID
     */
    private String agentId;
    
    /**
     * 上下文ID
     */
    private String contextId;
    
    /**
     * 用户消息
     */
    private String userMessage;
    
    /**
     * Agent响应
     */
    private String agentResponse;
    
    /**
     * 提示词Token数
     */
    private Integer promptTokens;
    
    /**
     * 生成Token数
     */
    private Integer completionTokens;
    
    /**
     * 总Token数
     */
    private Integer totalTokens;
    
    /**
     * 处理时间（毫秒）
     */
    private Long processingTime;
    
    /**
     * 结束原因（stop/tool_call/limit）
     */
    private String finishReason;
    
    /**
     * 工具调用列表（JSON格式）
     */
    private String toolCalls;
    
    /**
     * 会话用户
     */
    private String userId;
    

}
