package pangea.hiagent.llm;

import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import pangea.hiagent.model.LlmConfig;

/**
 * LLM模型工厂类
 * 用于根据配置动态创建ChatModel实例
 */
@Slf4j
@Component
public class LlmModelFactory {
    
    @Autowired
    private ModelAdapterManager modelAdapterManager;
    
    public ModelAdapterManager getModelAdapterManager() {
        return modelAdapterManager;
    }
    
    /**
     * 根据配置创建ChatModel实例
     * 
     * @param config LLM配置
     * @return ChatModel实例
     */
    public ChatModel createChatModel(LlmConfig config) {
        return modelAdapterManager.createChatModel(config);
    }
}