package pangea.hiagent.web.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 定时器执行历史DTO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TimerExecutionHistoryDto {
    private String id;
    private String timerId;
    private String timerName;
    private LocalDateTime executionTime;
    private Integer success;
    private String result;
    private String errorMessage;
    private Long executionDuration;
    private String actualPrompt;
    private LocalDateTime createdAt;
}
