@echo off
chcp 65001 >nul
REM HiAgent 后端Debug启动脚本
REM 此脚本用于启动Spring Boot应用进行远程调试

setlocal enabledelayedexpansion

echo.
echo ========================================
echo   HiAgent 后端Debug调试启动
echo ========================================
echo.

@REM REM 设置DeepSeek API密钥（从环境变量或提示用户输入）
@REM if "%DEEPSEEK_API_KEY%"=="" (
@REM     echo 请输入您的DeepSeek API密钥:
@REM     set /p DEEPSEEK_API_KEY=""
@REM     echo.
@REM )

REM 检查Java是否安装
java -version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] 未找到Java安装，请确保JDK 17+已安装
    pause
    exit /b 1
)

REM 进入后端目录
cd /d "%~dp0backend"

echo [INFO] 清理旧的构建文件...
call mvn clean -q -Dfile.encoding=UTF-8

REM 检查Lombok配置
echo [INFO] 检查Lombok配置...

REM 检查Maven Lombok插件
call mvn help:describe -Dplugin=lombok >nul 2>&1
if errorlevel 1 (
    echo [WARN] Maven Lombok插件未找到
) else (
    echo [INFO] Maven Lombok插件已安装
)

REM 检查项目中是否包含Lombok依赖
findstr /C:"org.projectlombok" pom.xml >nul 2>&1
if errorlevel 1 (
    echo [WARN] 项目pom.xml中未找到Lombok依赖
) else (
    echo [INFO] 项目pom.xml中包含Lombok依赖
)

REM 检查Java编译器注解处理器配置
echo [INFO] 检查Maven编译器插件中的注解处理器配置...
findstr /C:"annotationProcessorPaths" pom.xml >nul 2>&1
if errorlevel 1 (
    echo [WARN] pom.xml中未配置注解处理器路径
) else (
    echo [INFO] pom.xml中已配置注解处理器路径
)

REM 验证Lombok是否正常工作
echo [INFO] 验证Lombok是否正常工作...
REM call 
REM if errorlevel 1 (
REM     echo [WARN] 未检测到Lombok处理活动
REM ) else (
REM     echo [INFO] 检测到Lombok处理活动
REM )

echo [INFO] 重新编译项目...
call mvn clean compile -Dfile.encoding=UTF-8 -DskipTests
if errorlevel 1 (
    echo [ERROR] 编译失败，请检查代码和Lombok配置
    echo [INFO] 尝试使用详细日志重新编译...
    call mvn clean compile -Dfile.encoding=UTF-8 -DskipTests -X
    if errorlevel 1 (
        echo [ERROR] 编译仍然失败，请检查错误信息
        pause
        exit /b 1
    )
)

echo [INFO] 启动应用（Debug模式）...
echo [INFO] 访问地址: http://localhost:8080
echo [INFO] Swagger UI: http://localhost:8080/swagger-ui.html
echo [INFO] 调试端口: 5005 (JDWP)
echo.

REM 确保日志目录存在
echo [INFO] 检查日志目录...
if not exist "logs" mkdir logs

REM 启动应用，开启JDWP调试端口5005，并设置调试相关JVM参数
set MAVEN_OPTS=-Dfile.encoding=UTF-8 -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=./logs/heapdump.hprof

echo [INFO] 设置Spring Boot调试参数...
echo [INFO] 启用详细日志记录
echo [INFO] 激活开发环境配置
REM echo [INFO] 开启WebSocket详细日志
REM echo [INFO] 开启安全框架详细日志
REM echo [INFO] 开启Lombok详细日志
set SPRING_PROFILES_ACTIVE=dev

REM 设置更多调试参数
set JAVA_OPTS=-Dfile.encoding=UTF-8 -Dspring.profiles.active=dev -Dlogging.level.root=DEBUG -Dlogging.level.pangea.hiagent=TRACE -Dlogging.level.org.springframework.web=DEBUG -Dlogging.level.org.springframework.security=DEBUG -Dlogging.level.org.springframework.web.socket=DEBUG -Dlogging.level.org.projectlombok=DEBUG

echo [INFO] 启动Spring Boot应用...
call mvn spring-boot:run -Dspring-boot.run.arguments="--spring.jpa.hibernate.ddl-auto=create-drop --logging.level.root=DEBUG --logging.level.pangea.hiagent=TRACE --logging.level.org.springframework.web=DEBUG --logging.level.org.springframework.security=DEBUG --logging.level.org.springframework.web.socket=DEBUG --logging.level.org.projectlombok=DEBUG"

pause