package pangea.hiagent.agent.data;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 完成事件数据构建器
 * 专门负责构建完成事件数据
 */
@Component
public class CompletionEventDataBuilder {
    
    @Autowired
    private MapPoolService mapPoolService;
    
    /**
     * 创建完成事件数据
     *
     * @param fullContent 完整内容
     * @return 完成事件数据
     */
    public Map<String, Object> createCompletionEventData(String fullContent) {
        Map<String, Object> data = mapPoolService.acquireMap();
        data.put("fullText", fullContent != null ? fullContent : "");
        data.put("isDone", true);
        data.put("type", "complete");
        data.put("timestamp", System.currentTimeMillis());
        return data;
    }
}
