package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 提示词模板实体类
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("hiagent_prompt_template")
public class PromptTemplate extends BaseEntity {

    /**
     * 模板名称
     */
    private String name;

    /**
     * 模板描述
     */
    private String description;

    /**
     * 模板内容
     */
    private String templateContent;

    /**
     * 参数Schema定义（JSON格式）
     */
    private String paramSchema;

    /**
     * 模板类型
     */
    private String templateType;

    /**
     * 是否为系统模板（0-自定义，1-系统）
     */
    private Integer isSystem;
}
