/**
 * 字符串工具函数模块
 * 提供字符串处理相关的实用函数
 */

/**
 * 【关键工具函数】处理后端转义的HTML内容
 * 后端使用escapeHtmlContent()转义HTML，但这不是标准JSON转义
 * 需要特殊处理来还原原始HTML
 * @param content - 需要反转义的HTML内容
 * @returns 反转义后的HTML内容
 */
export const unescapeHtmlContent = (content: string): string => {
  if (!content) return content;
  
  try {
    // 检查是否包含转义标记
    if (!content.includes('\\')) {
      // 没有转义标记，直接返回
      return content;
    }
    
    console.log('检测到HTML内容可能被转义，开始还原...');
    
    let unescaped = content;
    
    // 还原基本的转义序列
    // 注意顺序很重要：先处理\\，再处理其他的
    unescaped = unescaped.replace(/\\\\/g, '\\');     // \\: \
    unescaped = unescaped.replace(/\\\"/g, '"');      // \": "
    unescaped = unescaped.replace(/\\'/g, "'");       // \': '
    unescaped = unescaped.replace(/\\n/g, '\n');      // \n: 换行符
    unescaped = unescaped.replace(/\\r/g, '\r');      // \r: 回车符
    unescaped = unescaped.replace(/\\t/g, '\t');      // \t: 制表符
    unescaped = unescaped.replace(/\\b/g, '\b');      // \b: 退格符
    unescaped = unescaped.replace(/\\f/g, '\f');      // \f: 换页符
    
    // 处理Unicode转义序列 \\uXXXX
    unescaped = unescaped.replace(/\\u([0-9a-fA-F]{4})/g, (match, code) => {
      return String.fromCharCode(parseInt(code, 16));
    });
    
    console.log('HTML内容还原完成，长度: ' + unescaped.length + ' 字节');
    return unescaped;
  } catch (e) {
    console.warn('HTML内容还原失败: ' + (e as Error).message + '，使用原始内容');
    return content;
  }
};