-- HiAgent数据库表结构初始化脚本
-- 用户表
CREATE TABLE IF NOT EXISTS sys_user (
  id varchar(36) NOT NULL,
  username varchar(50) NOT NULL UNIQUE,
  password varchar(255) NOT NULL,
  email varchar(100),
  nickname varchar(100),
  status varchar(20) DEFAULT 'active',
  role varchar(50) DEFAULT 'user',
  avatar varchar(255),
  last_login_time bigint,
  api_key varchar(255),
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);
CREATE INDEX IF NOT EXISTS idx_username ON sys_user (username);

-- Agent表
CREATE TABLE IF NOT EXISTS agent (
  id varchar(36) NOT NULL,
  name varchar(100) NOT NULL,
  description text,
  status varchar(20) DEFAULT 'active',
  default_model varchar(50),
  system_prompt text,
  prompt_template text,
  temperature decimal(3,2) DEFAULT 0.7,
  max_tokens int DEFAULT 4096,
  top_p decimal(3,2) DEFAULT 0.9,
  top_k int DEFAULT 50,
  presence_penalty decimal(3,2) DEFAULT 0,
  frequency_penalty decimal(3,2) DEFAULT 0,
  history_length int DEFAULT 10,
  tools json,
  rag_collection_id varchar(36),
  enable_rag tinyint DEFAULT 0,
  enable_react tinyint DEFAULT 0,
  owner varchar(36),
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);
CREATE INDEX IF NOT EXISTS idx_owner ON agent (owner);

-- 工具表
CREATE TABLE IF NOT EXISTS tool (
  id varchar(36) NOT NULL,
  name varchar(100) NOT NULL,
  display_name varchar(100),
  description text,
  category varchar(50),
  status varchar(20) DEFAULT 'active',
  parameters json,
  return_type varchar(50),
  return_schema json,
  implementation text,
  timeout bigint,
  api_endpoint varchar(255),
  http_method varchar(20),
  owner varchar(36),
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);

-- 文档表
CREATE TABLE IF NOT EXISTS document (
  id varchar(36) NOT NULL,
  name varchar(255) NOT NULL,
  type varchar(20),
  size bigint,
  status varchar(20) DEFAULT 'uploading',
  chunks int DEFAULT 0,
  collection_id varchar(36),
  file_path varchar(255),
  author varchar(100),
  source varchar(100),
  tags json,
  metadata json,
  embedding_model varchar(100),
  error_message text,
  owner varchar(36),
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);

-- 文档片段表
CREATE TABLE IF NOT EXISTS document_chunk (
  id varchar(36) NOT NULL,
  document_id varchar(36) NOT NULL,
  content longtext,
  page_number int,
  score decimal(3,2),
  sequence int,
  vector_id bigint,
  metadata json,
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);
CREATE INDEX IF NOT EXISTS idx_document_id ON document_chunk (document_id);

-- Agent对话表
CREATE TABLE IF NOT EXISTS agent_dialogue (
  id varchar(36) NOT NULL,
  agent_id varchar(36) NOT NULL,
  context_id varchar(36),
  user_message longtext,
  agent_response longtext,
  prompt_tokens int,
  completion_tokens int,
  total_tokens int,
  processing_time bigint,
  finish_reason varchar(50),
  tool_calls json,
  user_id varchar(36),
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);
CREATE INDEX IF NOT EXISTS idx_agent_id ON agent_dialogue (agent_id);
CREATE INDEX IF NOT EXISTS idx_user_id ON agent_dialogue (user_id);

-- 系统日志表
CREATE TABLE IF NOT EXISTS sys_log (
  id varchar(36) NOT NULL,
  operation_type varchar(50),
  resource_type varchar(50),
  resource_id varchar(36),
  user_id varchar(36),
  description text,
  request_params json,
  response_result json,
  success tinyint DEFAULT 1,
  error_message text,
  ip_address varchar(50),
  execution_time bigint,
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);
-- LLM配置表
CREATE TABLE IF NOT EXISTS llm_config (
  id varchar(36) NOT NULL,
  name varchar(100) NOT NULL UNIQUE,
  description text,
  provider varchar(50),
  model_name varchar(100),
  api_key varchar(255),
  base_url varchar(255),
  temperature decimal(3,2) DEFAULT 0.7,
  max_tokens int DEFAULT 4096,
  top_p decimal(3,2) DEFAULT 0.9,
  enabled tinyint DEFAULT 1,
  owner varchar(36),
  created_at timestamp DEFAULT CURRENT_TIMESTAMP,
  updated_at timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  created_by varchar(36),
  updated_by varchar(36),
  deleted int DEFAULT 0,
  remark text,
  PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS idx_user_id ON sys_log (user_id);
CREATE INDEX IF NOT EXISTS idx_created_at ON sys_log (created_at);