package pangea.hiagent.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import pangea.hiagent.model.Tool;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * 时间工具服务类
 * 提供获取当前时间的功能
 */
@Slf4j
@Service
public class TimeToolService {
    
    /**
     * 执行时间工具调用
     * 
     * @param tool 工具信息
     * @param parameters 工具参数
     * @return 当前时间的字符串表示
     */
    public String executeTimeTool(Tool tool, Map<String, Object> parameters) {
        log.info("执行时间工具调用: {}", tool.getName());
        
        try {
            // 获取当前时间
            LocalDateTime now = LocalDateTime.now();
            
            // 格式化时间
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedTime = now.format(formatter);
            
            // 构造返回结果
            return "{\n" +
                   "  \"currentTime\": \"" + formattedTime + "\",\n" +
                   "  \"timestamp\": " + System.currentTimeMillis() + "\n" +
                   "}";
        } catch (Exception e) {
            log.error("时间工具调用失败: {}", tool.getName(), e);
            return "{\n" +
                   "  \"error\": \"时间工具调用失败\",\n" +
                   "  \"message\": \"" + e.getMessage() + "\"\n" +
                   "}";
        }
    }
}