-- 插入默认数据

-- 插入默认用户数据
MERGE INTO sys_user (id, username, password, email, nickname, status, role) VALUES 
('user-001', 'admin', '$2a$10$N.zmdr9k7uOCQb0bta/OauRxaOKSr.QhqyD2R5FKvMQjmHoLkm5Sy', 'admin@hiagent.com', 'Admin', 'active', 'admin');

-- 插入默认LLM配置数据
MERGE INTO llm_config (id, name, description, provider, model_name, api_key, base_url, temperature, max_tokens, top_p, enabled, owner) VALUES 
('deepseek-default', 'deepseek-default', 'DeepSeek默认配置', 'deepseek', 'deepseek-chat', '', 'https://api.deepseek.com', 0.7, 4096, 0.9, true, 'user-001'),
('openai-default', 'openai-default', 'OpenAI默认配置', 'openai', 'gpt-3.5-turbo', '', 'https://api.openai.com/v1', 0.7, 4096, 0.9, false, 'user-001'),
('ollama-default', 'ollama-default', 'Ollama默认配置', 'ollama', 'llama2', '', 'http://localhost:11434', 0.7, 4096, 0.9, true, 'user-001'),
('hisense-default', 'hisense-default', 'Hisense默认配置', 'hisense', 'gpt-4-1', '', 'http://openai-proxy-v2-jt-higpt.cloudprd.hisense.com', 0.7, 4096, 0.9, true, 'user-001');

-- 插入默认Agent数据
MERGE INTO agent (id, name, description, status, default_model, owner, system_prompt, enable_re_act, history_length, enable_rag, rag_collection_id, rag_top_k, rag_score_threshold, top_k, presence_penalty, frequency_penalty, prompt_template, rag_prompt_template, enable_streaming) VALUES 
('agent-1', '客服助手', '处理客户咨询的AI助手', 'active', 'deepseek-default', 'user-001', '你是一个专业的客服助手，请用友好和专业的态度回答客户的问题。', 1, 15, 1, 'customer-service-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-2', '技术支持', '提供技术支持服务的AI助手', 'active', 'openai-default', 'user-001', '你是一个技术专家，请帮助用户解决技术问题。', 1, 15, 1, 'technical-support-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-3', '数据分析员', '专业的数据分析AI助手', 'active', 'deepseek-default', 'user-001', '你是一个数据分析专家，擅长处理和分析各种数据。', 0, 15, 1, 'data-analysis-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-4', '内容创作助手', '帮助撰写各类文案的AI助手', 'active', 'hisense-default', 'user-001', '你是一个创意写作专家，能够帮助用户创作各种类型的文案。', 0, 15, 1, 'content-creation-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-5', '学习导师', '个性化学习指导AI助手', 'active', 'hisense-default', 'user-001', '你是一个教育专家，能够根据用户需求提供个性化的学习建议。', 1, 15, 1, 'learning-mentor-kb', 5, 0.8, 50, 0, 0, '', '', 1);

-- 插入Agent和Tool的关联关系
MERGE INTO agent_tool_relation (id, agent_id, tool_id) VALUES
('relation-4', 'agent-2', 'tool-1'),
('relation-5', 'agent-2', 'tool-2'),
('relation-6', 'agent-2', 'tool-5'),
('relation-7', 'agent-2', 'tool-6'),
('relation-8', 'agent-3', 'tool-2'),
('relation-9', 'agent-3', 'tool-7'),
('relation-10', 'agent-3', 'tool-8'),
('relation-11', 'agent-4', 'tool-1'),
('relation-12', 'agent-4', 'tool-9'),
('relation-13', 'agent-4', 'tool-10'),
('relation-14', 'agent-5', 'tool-1'),
('relation-15', 'agent-5', 'tool-11'),
('relation-16', 'agent-5', 'tool-12');

-- 插入默认工具数据
MERGE INTO tool (id, name, display_name, description, category, status, owner, timeout, http_method, parameters, return_type, return_schema, implementation, api_endpoint, headers, auth_type, auth_config) VALUES 
('tool-1', 'search', '搜索工具', '进行网络搜索查询', 'API', 'active', 'user-001', 30000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-2', 'calculator', '计算器', '进行数学计算', 'FUNCTION', 'active', 'user-001', 5000, 'POST', '{}', 'number', '{}', '', '', '{}', '', '{}'),
('tool-3', 'weather', '天气查询', '查询天气信息', 'API', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-4', 'get_current_time', '获取当前时间', '获取当前系统时间', 'FUNCTION', 'active', 'user-001', 1000, 'GET', '{}', 'string', '{}', '', '', '{}', '', '{}'),
('tool-5', 'technicalDocumentationRetrieval', '技术文档检索', '检索和查询技术文档内容', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-6', 'technicalCodeExplanation', '技术代码解释', '分析和解释技术代码的功能和实现逻辑', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-7', 'chartGeneration', '图表生成', '根据数据生成各种类型的图表', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-8', 'statisticalCalculation', '统计计算', '执行各种统计分析计算', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-9', 'writingStyleReference', '创作风格参考', '提供各种写作风格的参考和指导', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-10', 'documentTemplate', '文档模板', '提供各种类型的文档模板', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-11', 'studyPlanGeneration', '学习计划制定', '根据学习目标和时间安排制定个性化的学习计划', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-12', 'courseMaterialRetrieval', '课程资料检索', '检索和查询相关课程资料', 'FUNCTION', 'active', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}');

-- 插入默认工具配置数据
MERGE INTO tool_configs (id, tool_name, param_name, param_value, description, default_value, type, required, group_name) VALUES 
('config-1', 'search', 'apiKey', 'test-key-123', '搜索引擎API密钥', '', 'string', 1, 'auth'),
('config-2', 'search', 'endpoint', 'https://api.search.com/v1/search', '搜索引擎API端点', 'https://api.search.com/v1/search', 'string', 1, 'connection');