import { createRouter, createWebHistory, RouteRecordRaw } from 'vue-router'
import { useAuthStore } from '@/stores/auth'

const routes: RouteRecordRaw[] = [
  {
    path: '/',
    redirect: '/dashboard'
  },
  {
    path: '/login',
    name: 'Login',
    component: () => import('@/pages/Login.vue'),
    meta: { requiresAuth: false }
  },
  {
    path: '/register',
    name: 'Register',
    component: () => import('@/pages/Register.vue'),
    meta: { requiresAuth: false }
  },
  {
    path: '/dashboard',
    name: 'Dashboard',
    component: () => import('@/pages/Dashboard.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/agent',
    name: 'AgentManagement',
    component: () => import('@/pages/AgentManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/documents',
    name: 'DocumentManagement',
    component: () => import('@/pages/DocumentManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/memory',
    name: 'MemoryManagement',
    component: () => import('@/pages/MemoryManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/llm-config',
    name: 'LlmConfigManagement',
    component: () => import('@/pages/LlmConfigManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/oauth2-providers',
    name: 'OAuth2ProviderManagement',
    component: () => import('@/pages/OAuth2ProviderManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/chat',
    name: 'Chat',
    component: () => import('@/pages/ChatPage.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/tools',
    name: 'ToolManagement',
    component: () => import('@/pages/ToolManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/system',
    name: 'SystemManagement',
    component: () => import('@/pages/SystemManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/timer',
    name: 'TimerManagement',
    component: () => import('@/pages/TimerManagement.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/dom-sync',
    name: 'DomSync',
    component: () => import('@/pages/DomSyncPage.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/new-chat',
    name: 'NewChat',
    component: () => import('@/pages/NewChatPage.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/test-timeline',
    name: 'TestTimeline',
    component: () => import('@/pages/SimplifiedTestTimeline.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/:pathMatch(.*)*',
    name: 'NotFound',
    redirect: '/dashboard'
  }
]
const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes
})

router.beforeEach((to, from, next) => {
  const authStore = useAuthStore()
  const requiresAuth = to.meta.requiresAuth
  
  if (requiresAuth && !authStore.token) {
    next('/login')
  } else if ((to.path === '/login' || to.path === '/register') && authStore.token) {
    next('/dashboard')
  } else {
    next()
  }
})

export default router