package pangea.hiagent.agent.react;

import org.springframework.ai.chat.client.ChatClient;

import pangea.hiagent.agent.service.SseTokenEmitter;
import pangea.hiagent.model.Agent;
import java.util.List;
import java.util.function.Consumer;

/**
 * ReAct执行器接口
 */
public interface ReactExecutor {
    
    /**
     * 执行ReAct流程（同步方式）
     * @param chatClient ChatClient实例
     * @param userInput 用户输入
     * @param tools 工具列表
     * @param agent Agent对象
     * @return 最终答案
     */
    String execute(ChatClient chatClient, String userInput, List<Object> tools, Agent agent);
    
    /**
     * 执行ReAct流程（同步方式）
     * @param chatClient ChatClient实例
     * @param userInput 用户输入
     * @param tools 工具列表
     * @param agent Agent对象
     * @param userId 用户ID
     * @return 最终答案
     */
    String execute(ChatClient chatClient, String userInput, List<Object> tools, Agent agent, String userId);
    
    /**
     * 流式执行ReAct流程
     * @param chatClient ChatClient实例
     * @param userInput 用户输入
     * @param tools 工具列表
     * @param tokenConsumer token处理回调函数
     * @param agent Agent对象
     * @param userId 用户ID
     */
    void executeStream(ChatClient chatClient, String userInput, List<Object> tools, SseTokenEmitter tokenConsumer, Agent agent, String userId);
    
    /**
     * 流式执行ReAct流程（旧方法，保持向后兼容）
     * @param chatClient ChatClient实例
     * @param userInput 用户输入
     * @param tools 工具列表
     * @param tokenConsumer token处理回调函数
     * @param agent Agent对象
     */
    void executeStream(ChatClient chatClient, String userInput, List<Object> tools, SseTokenEmitter tokenConsumer, Agent agent);
    
    /**
     * 添加ReAct回调
     * @param callback ReAct回调
     */
    void addReactCallback(ReactCallback callback);
}