-- 插入默认数据

-- 插入默认用户数据
MERGE INTO sys_user (id, username, password, email, nickname, status, role) VALUES 
('user-001', 'admin', '$2a$10$N.zmdr9k7uOCQb0bta/OauRxaOKSr.QhqyD2R5FKvMQjmHoLkm5Sy', 'admin@hiagent.com', 'Admin', 'active', 'admin');

-- 插入默认LLM配置数据
MERGE INTO llm_config (id, name, description, provider, model_name, api_key, base_url, temperature, max_tokens, top_p, enabled, owner) VALUES 
('deepseek-default', 'deepseek-default', 'DeepSeek默认配置', 'deepseek', 'deepseek-chat', '', 'https://api.deepseek.com', 0.7, 4096, 0.9, true, 'user-001'),
('openai-default', 'openai-default', 'OpenAI默认配置', 'openai', 'gpt-3.5-turbo', '', 'https://api.openai.com/v1', 0.7, 4096, 0.9, false, 'user-001'),
('ollama-default', 'ollama-default', 'Ollama默认配置', 'ollama', 'llama2', '', 'http://localhost:11434', 0.7, 4096, 0.9, true, 'user-001'),
('hisense-default', 'hisense-default', 'Hisense默认配置', 'hisense', 'gpt-4-1', '', 'http://openai-proxy-v2-jt-higpt.cloudprd.hisense.com', 0.7, 4096, 0.9, true, 'user-001');

-- 插入默认Agent数据
MERGE INTO agent (id, name, description, status, default_model, owner, system_prompt, enable_re_act, history_length, enable_rag, rag_collection_id, rag_top_k, rag_score_threshold, top_k, presence_penalty, frequency_penalty, prompt_template, rag_prompt_template, enable_streaming) VALUES 
('agent-1', '客服助手', '处理客户咨询的AI助手', 'active', 'deepseek-default', 'user-001', '你是一个专业的客服助手，请用友好和专业的态度回答客户的问题。', 1, 15, 1, 'customer-service-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-2', '技术支持', '提供技术支持服务的AI助手', 'active', 'openai-default', 'user-001', '你是一个技术专家，请帮助用户解决技术问题。', 1, 15, 1, 'technical-support-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-3', '数据分析员', '专业的数据分析AI助手', 'active', 'deepseek-default', 'user-001', '你是一个数据分析专家，擅长处理和分析各种数据。', 0, 15, 1, 'data-analysis-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-4', '内容创作助手', '帮助撰写各类文案的AI助手', 'active', 'hisense-default', 'user-001', '你是一个创意写作专家，能够帮助用户创作各种类型的文案。', 0, 15, 1, 'content-creation-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-5', '学习导师', '个性化学习指导AI助手', 'active', 'hisense-default', 'user-001', '你是一个教育专家，能够根据用户需求提供个性化的学习建议。', 1, 15, 1, 'learning-mentor-kb', 5, 0.8, 50, 0, 0, '', '', 1),
('agent-6', '海信流程审批助手', '专业的海信业务流程审批AI助手，支持SSO登录和各种审批操作', 'active', 'hisense-default', 'user-001', '你是一个海信业务流程审批助手，可以帮助用户处理海信SSO登录和各类审批操作，包括请假审批、自驾车审批、调休审批等。', 1, 3, 0, '', 5, 0.8, 50, 0, 0, '', '', 1);

-- 插入默认工具数据 (必须在agent_tool_relation之前插入)
MERGE INTO tool (id, name, display_name, description, category, status, bean_name, owner, timeout, http_method, parameters, return_type, return_schema, implementation, api_endpoint, headers, auth_type, auth_config) VALUES 
('tool-1', 'search', '搜索工具', '进行网络搜索查询', 'API', 'active', 'searchTool', 'user-001', 30000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-2', 'calculator', '计算器', '进行数学计算', 'FUNCTION', 'active', 'calculatorTools', 'user-001', 5000, 'POST', '{}', 'number', '{}', '', '', '{}', '', '{}'),
('tool-3', 'weather', '天气查询', '查询天气信息', 'API', 'active', 'weatherFunction', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-4', 'get_current_time', '获取当前时间', '获取当前系统时间', 'FUNCTION', 'active', 'dateTimeTools', 'user-001', 1000, 'GET', '{}', 'string', '{}', '', '', '{}', '', '{}'),
('tool-5', 'technicalDocumentationRetrieval', '技术文档检索', '检索和查询技术文档内容', 'FUNCTION', 'active', 'technicalDocumentationRetrievalTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-6', 'technicalCodeExplanation', '技术代码解释', '分析和解释技术代码的功能和实现逻辑', 'FUNCTION', 'active', 'technicalCodeExplanationTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-7', 'chartGeneration', '图表生成', '根据数据生成各种类型的图表', 'FUNCTION', 'active', 'chartGenerationTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-8', 'statisticalCalculation', '统计计算', '执行各种统计分析计算', 'FUNCTION', 'active', 'statisticalCalculationTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-9', 'writingStyleReference', '创作风格参考', '提供各种写作风格的参考和指导', 'FUNCTION', 'active', 'writingStyleReferenceTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-10', 'documentTemplate', '文档模板', '提供各种类型的文档模板', 'FUNCTION', 'active', 'documentTemplateTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-11', 'studyPlanGeneration', '学习计划制定', '根据学习目标和时间安排制定个性化的学习计划', 'FUNCTION', 'active', 'studyPlanGenerationTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-12', 'courseMaterialRetrieval', '课程资料检索', '检索和查询相关课程资料', 'FUNCTION', 'active', 'courseMaterialRetrievalTool', 'user-001', 10000, 'GET', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-13', 'emailTools', '邮件工具', '提供基于POP3协议的邮件访问功能', 'FUNCTION', 'active', 'emailTools', 'user-001', 30000, 'POST', '{"defaultPop3Port": 995, "defaultAttachmentPath": "attachments", "pop3SslEnable": true, "pop3SocketFactoryClass": "javax.net.ssl.SSLSocketFactory"}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-14', 'fileProcessing', '文件处理工具', '提供文件读写和管理功能，支持多种文本格式文件', 'FUNCTION', 'active', 'fileProcessingTools', 'user-001', 10000, 'POST', '{"textFileExtensions": ".txt,.md,.java,.html,.htm,.css,.js,.json,.xml,.yaml,.yml,.properties,.sql,.py,.cpp,.c,.h,.cs,.php,.rb,.go,.rs,.swift,.kt,.scala,.sh,.bat,.cmd,.ps1,.log,.csv,.ts,.jsx,.tsx,.vue,.scss,.sass,.less", "imageFileExtensions": ".jpg,.jpeg,.png,.gif,.bmp,.svg,.webp,.ico", "defaultStorageDir": "storage"}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-15', 'hisenseSsoAuth', '海信SSO认证工具', '用于访问需要SSO认证的海信业务系统，自动完成登录并提取页面内容', 'FUNCTION', 'active', 'hisenseSsoAuthTool', 'user-001', 60000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-16', 'oauth2Authorization', 'OAuth2.0授权工具', '支持标准OAuth2.0认证流程，包括密码凭证流、令牌刷新和受保护资源访问', 'FUNCTION', 'active', 'oauth2AuthorizationTool', 'user-001', 30000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-17', 'orderQuery', '订单查询工具', '用于查询客户订单信息', 'FUNCTION', 'active', 'orderQueryTool', 'user-001', 10000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-18', 'playwrightWeb', 'Playwright网页自动化工具', '提供基于Playwright的网页内容抓取、交互操作、截图等功能', 'FUNCTION', 'active', 'playwrightWebTools', 'user-001', 30000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-19', 'refundProcessing', '退款处理工具', '用于处理客户退款申请', 'FUNCTION', 'active', 'refundProcessingTool', 'user-001', 10000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-20', 'storageFileAccess', '存储文件访问工具', '提供访问服务器后端 storage 目录下文件的功能', 'FUNCTION', 'active', 'storageFileAccessTool', 'user-001', 10000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-21', 'stringProcessing', '字符串处理工具', '提供字符串处理和转换功能', 'FUNCTION', 'active', 'stringProcessingTools', 'user-001', 5000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-22', 'webPageAccess', '网页访问工具', '提供根据网站名称或URL地址访问网页并在工作面板中预览的功能', 'FUNCTION', 'active', 'webPageAccessTools', 'user-001', 30000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-71', 'hisenseSsoLogin', '海信SSO登录工具', '用于登录海信SSO系统，需要提供用户ID以区分会话', 'FUNCTION', 'active', 'hisenseSsoLoginTool', 'user-001', 60000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-72', 'hisenseLbpmApproval', '海信LBPM流程审批工具', '处理海信请假审批、自驾车审批、调休审批，需要先使用HisenseSsoLoginTool登录，提供用户ID以区分会话', 'FUNCTION', 'active', 'hisenseLbpmApprovalTool', 'user-001', 60000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}'),
('tool-73', 'hisensePerformanceApproval', '海信绩效系统审批工具', '处理海信绩效系统审批，检查海信SSO是否处于登录状态，自动审批所有待处理流程', 'FUNCTION', 'active', 'hisensePerformanceApprovalTool', 'user-001', 60000, 'POST', '{}', 'object', '{}', '', '', '{}', '', '{}');

-- Agent和Tool的关联关系 (必须在tool数据插入完成后执行)
MERGE INTO agent_tool_relation (id, agent_id, tool_id) VALUES
('relation-5', 'agent-2', 'tool-2'),
('relation-6', 'agent-2', 'tool-5'),
('relation-7', 'agent-2', 'tool-6'),
('relation-8', 'agent-3', 'tool-2'),
('relation-9', 'agent-3', 'tool-7'),
('relation-10', 'agent-3', 'tool-8'),
('relation-12', 'agent-4', 'tool-9'),
('relation-13', 'agent-4', 'tool-10'),
('relation-15', 'agent-5', 'tool-11'),
('relation-17', 'agent-2', 'tool-3'),
('relation-18', 'agent-4', 'tool-3'),
('relation-19', 'agent-5', 'tool-3'),
('relation-20', 'agent-6', 'tool-4'),
('relation-21', 'agent-6', 'tool-71'),
('relation-22', 'agent-6', 'tool-72'),
('relation-23', 'agent-6', 'tool-73');

-- 插入默认工具配置数据
MERGE INTO tool_configs (id, tool_name, param_name, param_value, description, default_value, type, required, group_name) VALUES 
('config-1', 'search', 'apiKey', 'test-key-123', '搜索引擎API密钥', '', 'string', 1, 'auth'),
('config-2', 'search', 'endpoint', 'https://api.search.com/v1/search', '搜索引擎API端点', 'https://api.search.com/v1/search', 'string', 1, 'connection'),
('config-3', 'emailTools', 'defaultPop3Port', '995', '默认POP3服务器端口', '995', 'integer', 1, 'email'),
('config-4', 'emailTools', 'defaultAttachmentPath', 'attachments', '默认附件保存路径', 'attachments', 'string', 1, 'email'),
('config-5', 'emailTools', 'pop3SslEnable', 'true', '是否启用POP3 SSL', 'true', 'boolean', 1, 'email'),
('config-6', 'emailTools', 'pop3SocketFactoryClass', 'javax.net.ssl.SSLSocketFactory', 'POP3 SSL套接字工厂类', 'javax.net.ssl.SSLSocketFactory', 'string', 1, 'email'),
('config-7', 'fileProcessing', 'textFileExtensions', '.txt,.md,.java,.html,.htm,.css,.js,.json,.xml,.yaml,.yml,.properties,.sql,.py,.cpp,.c,.h,.cs,.php,.rb,.go,.rs,.swift,.kt,.scala,.sh,.bat,.cmd,.ps1,.log,.csv,.ts,.jsx,.tsx,.vue,.scss,.sass,.less', '支持的文本文件扩展名，逗号分隔', '.txt,.md,.java,.html,.htm,.css,.js,.json,.xml,.yaml,.yml,.properties,.sql,.py,.cpp,.c,.h,.cs,.php,.rb,.go,.rs,.swift,.kt,.scala,.sh,.bat,.cmd,.ps1,.log,.csv,.ts,.jsx,.tsx,.vue,.scss,.sass,.less', 'string', 1, 'file'),
('config-8', 'fileProcessing', 'imageFileExtensions', '.jpg,.jpeg,.png,.gif,.bmp,.svg,.webp,.ico', '支持的图片文件扩展名，逗号分隔', '.jpg,.jpeg,.png,.gif,.bmp,.svg,.webp,.ico', 'string', 1, 'file'),
('config-9', 'fileProcessing', 'defaultStorageDir', 'storage', '默认文件存储目录', 'storage', 'string', 1, 'file'),
('config-10', 'hisenseSsoLogin', 'ssoUsername', '', '海信SSO登录用户名', '', 'string', 1, 'auth'),
('config-11', 'hisenseSsoLogin', 'ssoPassword', '', '海信SSO登录密码', '', 'string', 1, 'auth');