package pangea.hiagent.agent.react;

import java.io.IOException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import lombok.extern.slf4j.Slf4j;
import pangea.hiagent.agent.service.UserSseService;
import pangea.hiagent.common.utils.UserUtils;
import pangea.hiagent.web.dto.WorkPanelEvent;

/**
 * 简化的ReAct回调类
 */
@Slf4j
@Component
public class DefaultReactCallback implements ReactCallback {

    @Autowired
    private UserSseService userSseService;

    @Override
    public void onStep(ReactStep reactStep) {

        String reactStepName = reactStep.getStepType().name();

        try {
            userSseService.sendWorkPanelEvent(WorkPanelEvent.builder()
                    .type(reactStepName)
                    .content(reactStep.getContent())
                    .userId(UserUtils.getCurrentUserIdStatic())
                    .build());
        } catch (IOException e) {
            log.error("发送ReAct步骤到WorkPanel失败: 类型={}, 内容摘要={}",
                    reactStep.getStepType(),
                    reactStep.getContent() != null
                            ? reactStep.getContent().substring(0, Math.min(50, reactStep.getContent().length()))
                            : "null",
                    e);
        }

        // 记录最终答案到日志
        log.info("[WorkPanel] 记录{} {}", reactStepName,
                reactStep.getContent().substring(0, Math.min(100, reactStep.getContent().length())));

    }
}