package pangea.hiagent.scheduler;

import lombok.extern.slf4j.Slf4j;
import pangea.hiagent.web.service.TimerService;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

/**
 * 定时器任务执行类
 * 由Quartz调度器触发，执行具体的定时器任务
 */
@Slf4j
public class TimerJob extends QuartzJobBean {

    @Autowired
    private TimerService timerService;

    /**
     * 执行定时器任务
     * @param context 任务执行上下文，包含任务的参数信息
     */
    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            // 从上下文中获取定时器ID
            String timerId = context.getJobDetail().getJobDataMap().getString("timerId");
            log.info("开始执行定时器任务: {}", timerId);

            if (timerId == null || timerId.isEmpty()) {
                log.error("定时器任务缺少timerId参数");
                return;
            }

            // 调用TimerService执行定时器任务
            timerService.executeTimerTask(timerId);
            log.info("定时器任务执行完成: {}", timerId);
        } catch (Exception e) {
            log.error("定时器任务执行失败", e);
            throw new JobExecutionException(e);
        }
    }
}
