package pangea.hiagent.common.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

/**
 * 缓存配置类
 * 配置Caffeine缓存管理器以支持工具调用缓存
 */
@Configuration
@EnableCaching
public class CacheConfig {
    
    /**
     * 配置Caffeine缓存管理器
     */
    @Bean
    public CacheManager cacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        
        // 配置默认的Caffeine缓存
        cacheManager.setCaffeine(Caffeine.newBuilder()
                .maximumSize(1000) // 最大缓存条目数
                .expireAfterWrite(1, TimeUnit.HOURS) // 写入后1小时过期
                .recordStats()); // 记录缓存统计信息
        
        return cacheManager;
    }
    
    /**
     * 为工具调用结果配置专用缓存
     */
    @Bean
    public com.github.benmanes.caffeine.cache.Cache<String, Object> toolResultCache() {
        return Caffeine.newBuilder()
                .maximumSize(10000) // 更大的缓存容量
                .expireAfterWrite(30, TimeUnit.MINUTES) // 较短的过期时间
                .recordStats()
                .build();
    }
    
    /**
     * 为汇率信息配置专用缓存
     */
    @Bean("exchangeRates")
    public com.github.benmanes.caffeine.cache.Cache<String, Object> exchangeRatesCache() {
        return Caffeine.newBuilder()
                .maximumSize(1000)
                .expireAfterWrite(1, TimeUnit.HOURS) // 汇率信息相对稳定，可以缓存更长时间
                .recordStats()
                .build();
    }
    
    /**
     * 为天气信息配置专用缓存
     */
    @Bean("weatherInfo")
    public com.github.benmanes.caffeine.cache.Cache<String, Object> weatherInfoCache() {
        return Caffeine.newBuilder()
                .maximumSize(5000)
                .expireAfterWrite(10, TimeUnit.MINUTES) // 天气信息变化较快，缓存时间较短
                .recordStats()
                .build();
    }
}