package pangea.hiagent.web.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * 嵌入事件数据传输对象
 * 用于表示需要嵌入显示的事件（如网页预览等）
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class EmbedEvent extends WorkPanelEvent {
    private static final long serialVersionUID = 1L;
    
    /**
     * Embed事件信息 - 嵌入资源URL
     */
    private String embedUrl;
    
    /**
     * Embed事件信息 - MIME类型
     */
    private String embedType;
    
    /**
     * Embed事件信息 - 嵌入事件标题
     */
    private String embedTitle;
    
    /**
     * Embed事件信息 - HTML内容
     */
    private String embedHtmlContent;
}