package pangea.hiagent.web.controller;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import pangea.hiagent.agent.sse.UserSseService;
import pangea.hiagent.common.utils.UserUtils;
import pangea.hiagent.workpanel.event.EventService;

/**
 * 时间轴事件控制器
 * 提供ReAct过程的实时事件推送功能
 */
@Slf4j
@RestController
@RequestMapping("/api/v1/agent")
public class TimelineEventController {
    
    private final UserSseService workPanelSseService;
    public TimelineEventController(UserSseService workPanelSseService, EventService eventService) {
        this.workPanelSseService = workPanelSseService;
    }
    
    /**
     * 订阅时间轴事件
     * 支持 SSE (Server-Sent Events) 格式的实时事件推送
     * 
     * @return SSE emitter
     */
    @GetMapping("/timeline-events")
    public SseEmitter subscribeTimelineEvents() {
        log.info("开始处理时间轴事件订阅请求");
        
        // 获取当前认证用户ID
        String userId = UserUtils.getCurrentUserId();
        if (userId == null) {
            log.warn("用户未认证，无法创建时间轴事件订阅");
            throw new org.springframework.security.access.AccessDeniedException("用户未认证");
        }
        log.info("开始为用户 {} 创建SSE连接", userId);
        
        // 创建并注册SSE连接
        return workPanelSseService.createAndRegisterConnection(userId);
    }
}