package pangea.hiagent.tools;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.ai.tool.annotation.Tool;

/**
 * 计算器工具类
 * 提供基本的数学运算功能
 */
@Slf4j
@Component
public class CalculatorTools {
    
    @Tool(description = "执行两个数字的加法运算")
    public double add(double a, double b) {
        double result = a + b;
        log.debug("执行加法运算: {} + {} = {}", a, b, result);
        return result;
    }
    
    @Tool(description = "执行两个数字的减法运算")
    public double subtract(double a, double b) {
        double result = a - b;
        log.debug("执行减法运算: {} - {} = {}", a, b, result);
        return result;
    }
    
    @Tool(description = "执行两个数字的乘法运算")
    public double multiply(double a, double b) {
        double result = a * b;
        log.debug("执行乘法运算: {} * {} = {}", a, b, result);
        return result;
    }
    
    @Tool(description = "执行两个数字的除法运算")
    public String divide(double a, double b) {
        log.debug("执行除法运算: {} / {}", a, b);
        if (b == 0) {
            log.warn("除法运算错误：除数不能为零");
            return "错误：除数不能为零";
        }
        double result = a / b;
        log.debug("除法运算结果: {}", result);
        return String.valueOf(result);
    }
}