package pangea.hiagent;

import pangea.hiagent.model.Agent;
import java.util.List;
import java.util.Set;

/**
 * 简单测试类，用于验证Agent工具配置修复是否有效
 */
public class TestAgentToolsFix {
    
    public static void main(String[] args) {
        System.out.println("开始测试Agent工具配置修复...");
        
        // 创建Agent实例
        Agent agent = new Agent();
        agent.setId("test-agent-001");
        agent.setName("测试Agent");
        
        // 测试1: JSON数组格式
        System.out.println("\n=== 测试1: JSON数组格式 ===");
        agent.setTools("[\"search\", \"calculator\", \"weather\"]");
        List<String> toolNames = agent.getToolNames();
        System.out.println("工具名称列表: " + toolNames);
        System.out.println("工具数量: " + toolNames.size());
        
        Set<String> toolNameSet = agent.getToolNameSet();
        System.out.println("工具名称集合: " + toolNameSet);
        System.out.println("去重后工具数量: " + toolNameSet.size());
        
        // 测试2: 单个工具名称
        System.out.println("\n=== 测试2: 单个工具名称 ===");
        agent.setTools("single-tool");
        toolNames = agent.getToolNames();
        System.out.println("工具名称列表: " + toolNames);
        System.out.println("工具数量: " + toolNames.size());
        
        // 测试3: 无效JSON
        System.out.println("\n=== 测试3: 无效JSON ===");
        agent.setTools("invalid-json-format");
        toolNames = agent.getToolNames();
        System.out.println("工具名称列表: " + toolNames);
        System.out.println("工具数量: " + toolNames.size());
        
        // 测试4: 空工具配置
        System.out.println("\n=== 测试4: 空工具配置 ===");
        agent.setTools("");
        toolNames = agent.getToolNames();
        System.out.println("工具名称列表: " + toolNames);
        System.out.println("工具数量: " + toolNames.size());
        
        System.out.println("\n测试完成!");
    }
}