# 文件处理工具使用说明

## 功能概述

FileProcessingTools 是一个功能丰富的文件处理工具类，专门设计用于处理各种文本格式文件。该工具支持读取、写入、追加内容到文件，并提供文件信息查询功能。

支持的文件格式包括但不限于：
- 文本文件：`.txt`
- 标记语言文件：`.md`
- 编程语言文件：`.java`, `.html`, `.htm`, `.css`, `.js`, `.json`, `.xml`, `.yaml`, `.yml`, `.py`, `.cpp`, `.c`, `.h`, `.cs`, `.php`, `.rb`, `.go`, `.rs`, `.swift`, `.kt`, `.scala`
- 脚本文件：`.sh`, `.bat`, `.cmd`, `.ps1`
- 其他文本格式：`.properties`, `.sql`, `.log`, `.csv`, `.ts`, `.jsx`, `.tsx`, `.vue`, `.scss`, `.sass`, `.less`

## 功能列表

### 1. readFile(String filePath)
读取文本文件内容

**参数：**
- `filePath`: 文件路径（支持相对路径）

**返回值：**
- 成功时返回文件内容
- 失败时返回错误信息

**示例：**
```java
@Autowired
private FileProcessingTools fileTools;

String content = fileTools.readFile("/path/to/file.txt");
// 或使用相对路径
String content = fileTools.readFile("relative/path/to/file.txt");
```

### 2. readFileWithEncoding(String filePath, String encoding)
读取文本文件内容，支持指定字符编码

**参数：**
- `filePath`: 文件路径（支持相对路径）
- `encoding`: 字符编码（如 "UTF-8", "GBK" 等）

**返回值：**
- 成功时返回文件内容
- 失败时返回错误信息

**示例：**
```java
String content = fileTools.readFileWithEncoding("/path/to/file.txt", "UTF-8");
```

### 3. writeFile(String filePath, String content)
写入内容到文本文件

**参数：**
- `filePath`: 文件路径（支持相对路径，如果为空或null则自动生成随机文件名）
- `content`: 要写入的内容

**返回值：**
- 成功时返回"文件写入成功，文件路径: [完整文件路径]"
- 失败时返回错误信息

**示例：**
```java
// 指定文件名
String result = fileTools.writeFile("/path/to/file.txt", "Hello, World!");

// 使用相对路径
String result = fileTools.writeFile("relative/path/to/file.txt", "Hello, World!");

// 自动生成随机文件名
String result = fileTools.writeFile("", "Hello, World!");
```

### 4. writeFileWithEncoding(String filePath, String content, String encoding, boolean append)
写入内容到文本文件，支持指定字符编码和追加模式

**参数：**
- `filePath`: 文件路径（支持相对路径，如果为空或null则自动生成随机文件名）
- `content`: 要写入的内容
- `encoding`: 字符编码
- `append`: 是否追加到文件末尾（true为追加，false为覆盖）

**返回值：**
- 成功时返回"文件写入成功，文件路径: [完整文件路径]"
- 失败时返回错误信息

**示例：**
```java
// 覆盖写入
String result = fileTools.writeFileWithEncoding("/path/to/file.txt", "New content", "UTF-8", false);

// 追加写入
String result = fileTools.writeFileWithEncoding("/path/to/file.txt", "Additional content", "UTF-8", true);

// 自动生成随机文件名并写入
String result = fileTools.writeFileWithEncoding("", "Content with random filename", "UTF-8", false);
```

### 5. appendToFile(String filePath, String content)
追加内容到文本文件末尾

**参数：**
- `filePath`: 文件路径（支持相对路径，如果为空或null则自动生成随机文件名）
- `content`: 要追加的内容

**返回值：**
- 成功时返回"文件写入成功，文件路径: [完整文件路径]"
- 失败时返回错误信息

**示例：**
```java
String result = fileTools.appendToFile("/path/to/file.txt", "Appended content");
// 或使用相对路径
String result = fileTools.appendToFile("relative/path/to/file.txt", "Appended content");
// 或自动生成随机文件名
String result = fileTools.appendToFile("", "Appended content with random filename");
```

### 6. getFileSize(String filePath)
获取文件大小

**参数：**
- `filePath`: 文件路径（支持相对路径）

**返回值：**
- 成功时返回文件大小信息
- 失败时返回错误信息

**示例：**
```java
String sizeInfo = fileTools.getFileSize("/path/to/file.txt");
// 或使用相对路径
String sizeInfo = fileTools.getFileSize("relative/path/to/file.txt");
```

### 7. fileExists(String filePath)
检查文件是否存在

**参数：**
- `filePath`: 文件路径（支持相对路径）

**返回值：**
- 文件存在返回true
- 文件不存在返回false

**示例：**
```java
boolean exists = fileTools.fileExists("/path/to/file.txt");
// 或使用相对路径
boolean exists = fileTools.fileExists("relative/path/to/file.txt");
```

### 8. getFileInfo(String filePath)
获取文件详细信息

**参数：**
- `filePath`: 文件路径（支持相对路径）

**返回值：**
- 成功时返回文件详细信息（包括路径、大小、是否为文本文件、最后修改时间）
- 失败时返回错误信息

**示例：**
```java
String fileInfo = fileTools.getFileInfo("/path/to/file.txt");
// 或使用相对路径
String fileInfo = fileTools.getFileInfo("relative/path/to/file.txt");
```

### 9. generateRandomFileName(String extension)
生成随机文件名并返回完整路径

**参数：**
- `extension`: 文件扩展名（如 ".txt", "md" 等，如果不带点会自动添加）

**返回值：**
- 成功时返回完整文件路径
- 失败时返回错误信息

**示例：**
```java
String randomFilePath = fileTools.generateRandomFileName(".txt");
// 或不带点的扩展名
String randomFilePath = fileTools.generateRandomFileName("md");
```

## 使用注意事项

1. **字符编码**：默认使用UTF-8编码，可根据需要指定其他编码格式
2. **文件类型限制**：只能处理预定义的文本文件类型，非文本文件会被拒绝处理
3. **目录自动创建**：写入文件时会自动创建不存在的目录
4. **错误处理**：所有操作都有完善的错误处理和日志记录
5. **文件大小**：适合处理中小型文本文件，大文件处理可能影响性能
6. **路径支持**：支持相对路径，默认相对于当前工作目录
7. **随机文件名**：当filePath为空或null时，会自动生成随机文件名并存储在"storage"目录下
8. **扩展名推断**：当使用随机文件名时，会根据内容自动推断合适的文件扩展名

## 错误处理

工具类提供了完善的错误处理机制：
- 文件不存在时返回明确的错误信息
- 文件路径为空时自动生成随机文件名而不是报错
- IO异常时记录详细日志并返回友好的错误信息
- 编码错误时使用默认UTF-8编码并记录警告日志

## 性能优化

1. **内存使用**：使用NIO.2 API进行文件读写，提高效率
2. **字符编码**：自动检测和处理字符编码，确保内容正确性
3. **日志记录**：详细的日志记录便于问题排查和性能监控
4. **路径处理**：智能处理相对路径和绝对路径
5. **文件名生成**：使用UUID生成唯一的随机文件名，避免冲突

## 示例用法

```java
@Autowired
private FileProcessingTools fileTools;

// 读取文件
String content = fileTools.readFile("data/input.txt");

// 写入文件（自动生成随机文件名）
String writeResult = fileTools.writeFile("", "Hello, World!");
System.out.println(writeResult); // 输出文件路径

// 追加内容到文件
fileTools.appendToFile("logs/app.log", "New log entry\n");

// 获取文件信息
String fileInfo = fileTools.getFileInfo("config/settings.json");
```