package pangea.hiagent.model;

import org.junit.jupiter.api.Test;
import java.util.List;
import static org.junit.jupiter.api.Assertions.*;

class AgentToolNamesTest {

    @Test
    void testGetToolNamesWithNullTools() {
        Agent agent = new Agent();
        agent.setTools(null);
        
        List<String> toolNames = agent.getToolNames();
        assertEquals(2, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
    }

    @Test
    void testGetToolNamesWithEmptyTools() {
        Agent agent = new Agent();
        agent.setTools("");
        
        List<String> toolNames = agent.getToolNames();
        assertEquals(2, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
    }

    @Test
    void testGetToolNamesWithValidJsonArray() {
        Agent agent = new Agent();
        agent.setTools("[\"search\", \"calculator\", \"customTool\"]");
        
        List<String> toolNames = agent.getToolNames();
        assertEquals(3, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
        assertTrue(toolNames.contains("customTool"));
    }

    @Test
    void testGetToolNamesWithInvalidJsonArray() {
        Agent agent = new Agent();
        agent.setTools("[invalid json]");
        
        List<String> toolNames = agent.getToolNames();
        assertEquals(2, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
    }

    @Test
    void testGetToolNamesWithSingleToolName() {
        Agent agent = new Agent();
        agent.setTools("singleTool");
        
        List<String> toolNames = agent.getToolNames();
        assertEquals(1, toolNames.size());
        assertEquals("singleTool", toolNames.get(0));
    }

    @Test
    void testGetToolNamesWithEmptyJsonArray() {
        Agent agent = new Agent();
        agent.setTools("[]");
        
        List<String> toolNames = agent.getToolNames();
        assertEquals(2, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
    }
}