package pangea.hiagent.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;

/**
 * JWT配置属性类
 */
@Data
@ConfigurationProperties(prefix = "hiagent.jwt")
public class JwtProperties {
    
    /**
     * JWT密钥
     */
    private String secret = "hiagent-secret-key-for-production-change-this";
    
    /**
     * Token过期时间（毫秒）
     */
    private Long expiration = 7200000L; // 2小时
    
    /**
     * 刷新Token过期时间（毫秒）
     */
    private Long refreshExpiration = 604800000L; // 7天
}