// package pangea.hiagent.tools;

// import lombok.extern.slf4j.Slf4j;
// import org.jsoup.Jsoup;
// import org.jsoup.nodes.Document;
// import org.jsoup.nodes.Element;
// import org.jsoup.select.Elements;
// import org.springframework.ai.tool.annotation.Tool;
// import org.springframework.beans.BeansException;
// import org.springframework.context.ApplicationContext;
// import org.springframework.context.ApplicationContextAware;
// import org.springframework.stereotype.Component;
// import pangea.hiagent.core.IWorkPanelDataCollector;

// import java.io.BufferedReader;
// import java.io.InputStreamReader;
// import java.net.URL;
// import java.net.URLConnection;
// import java.util.HashMap;
// import java.util.regex.Pattern;

// /**
//  * 网页内容提取工具类
//  * 提供网页内容抓取和正文提取功能
//  */
// @Slf4j
// @Component
// public class WebContentExtractorTool implements ApplicationContextAware {
    
//     // Spring应用上下文引用
//     private static ApplicationContext applicationContext;
    
//     // 用户代理字符串
//     private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36";
    
//     // 连接和读取超时时间（毫秒）
//     private static final int CONNECT_TIMEOUT = 5000;
//     private static final int READ_TIMEOUT = 10000;
    
//     // 标题选择器优先级
//     private static final String[] TITLE_SELECTORS = {
//         "h1[class*=title], h1[id*=title]",
//         "h1:first-of-type",
//         "title",
//         "h1"
//     };
    
//     // 正文内容选择器优先级
//     private static final String[] CONTENT_SELECTORS = {
//         "[class*=content], [id*=content]",
//         "[class*=article], [id*=article]",
//         "[class*=post], [id*=post]",
//         "article",
//         ".main-content",
//         "#main-content",
//         "main"
//     };
    
//     /**
//      * 设置ApplicationContext引用
//      */
//     @Override
//     public void setApplicationContext(ApplicationContext context) throws BeansException {
//         WebContentExtractorTool.applicationContext = context;
//     }
    
//     /**
//      * 提取网页正文内容
//      * @param url 网页URL地址
//      * @return 提取的网页正文内容
//      */
//     @Tool(description = "提取指定网页的正文内容，自动识别并提取文章标题和主要内容，过滤掉广告、导航栏等无关内容")
//     public String extractWebContent(String url) {
//         log.debug("接收到网页内容提取请求: {}", url);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         recordToWorkPanel("extractWebContent", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         try {
//             // 自动补全URL协议
//             String completeUrl = completeUrlProtocol(url);
            
//             // 验证URL格式
//             if (!isValidUrl(completeUrl)) {
//                 long endTime = System.currentTimeMillis();
//                 log.warn("无效的URL格式: {}", completeUrl);
//                 String result = "无效的URL格式，请确保输入完整的网址，例如: https://www.example.com";
                
//                 // 记录失败结果
//                 recordToWorkPanel("extractWebContent", null, result, "failure", endTime - startTime);
//                 return result;
//             }
            
//             // 获取网页HTML内容
//             String htmlContent = fetchWebContent(completeUrl);
//             if (htmlContent == null || htmlContent.isEmpty()) {
//                 long endTime = System.currentTimeMillis();
//                 log.warn("获取网页内容失败: {}", completeUrl);
//                 String result = "获取网页内容失败，请检查网址是否正确";
                
//                 // 记录失败结果
//                 recordToWorkPanel("extractWebContent", null, result, "failure", endTime - startTime);
//                 return result;
//             }
            
//             // 提取正文内容
//             String extractedContent = extractContentFromHtml(htmlContent, completeUrl);
//             long endTime = System.currentTimeMillis();
            
//             log.info("成功提取网页内容: {}", completeUrl);
            
//             // 发送embed事件到工作面板
//             sendEmbedEvent(completeUrl, "text/plain", "网页内容提取结果", extractedContent);
            
//             // 记录成功结果
//             recordToWorkPanel("extractWebContent", null, "已成功提取网页内容", "success", endTime - startTime);
//             return extractedContent;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             log.error("提取网页内容时发生错误: {}, 错误详情: {}", url, e.getMessage(), e);
//             String errorMsg = "提取网页内容时发生错误: " + e.getMessage();
            
//             // 记录错误
//             recordToWorkPanel("extractWebContent", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 自动补全URL协议
//      * @param url 待补全的URL
//      * @return 补全后的URL
//      */
//     private String completeUrlProtocol(String url) {
//         if (url == null || url.isEmpty()) {
//             return url;
//         }
        
//         // 如果已经包含协议，则直接返回
//         if (url.startsWith("http://") || url.startsWith("https://")) {
//             return url;
//         }
        
//         // 默认添加https协议
//         return "https://" + url;
//     }
    
//     /**
//      * 验证URL格式是否有效
//      * @param url 待验证的URL
//      * @return 如果URL格式有效返回true，否则返回false
//      */
//     private boolean isValidUrl(String url) {
//         if (url == null || url.isEmpty()) {
//             return false;
//         }
        
//         // 检查是否包含协议
//         if (!url.startsWith("http://") && !url.startsWith("https://")) {
//             return false;
//         }
        
//         // 简单的URL格式检查
//         try {
//             new URL(url);
//             return true;
//         } catch (Exception e) {
//             return false;
//         }
//     }
    
//     /**
//      * 获取网页内容
//      * @param url 网页URL地址
//      * @return 网页HTML内容
//      */
//     private String fetchWebContent(String url) {
//         StringBuilder content = new StringBuilder();
//         BufferedReader reader = null;
        
//         try {
//             URLConnection connection = new URL(url).openConnection();
//             // 设置请求头，模拟浏览器访问
//             connection.setRequestProperty("User-Agent", USER_AGENT);
//             connection.setConnectTimeout(CONNECT_TIMEOUT);
//             connection.setReadTimeout(READ_TIMEOUT);
            
//             reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
//             String line;
//             while ((line = reader.readLine()) != null) {
//                 content.append(line).append("\n");
//             }
            
//             log.debug("成功获取网页内容，长度: {} bytes", content.length());
//             return content.toString();
            
//         } catch (Exception e) {
//             log.error("获取网页内容失败: {}", e.getMessage(), e);
//             return null;
//         } finally {
//             if (reader != null) {
//                 try {
//                     reader.close();
//                 } catch (Exception e) {
//                     log.debug("关闭读取器失败: {}", e.getMessage());
//                 }
//             }
//         }
//     }
    
//     /**
//      * 从HTML中提取正文内容
//      * @param html HTML内容
//      * @param url 网页URL
//      * @return 提取的正文内容
//      */
//     private String extractContentFromHtml(String html, String url) {
//         try {
//             Document doc = Jsoup.parse(html, url);
            
//             // 移除脚本和样式元素
//             doc.select("script, style, nav, header, footer, aside, .ad, .advertisement").remove();
            
//             StringBuilder content = new StringBuilder();
            
//             // 提取标题
//             String title = extractTitle(doc);
//             if (title != null && !title.isEmpty()) {
//                 content.append("# ").append(title).append("\n\n");
//             }
            
//             // 提取正文内容
//             String bodyContent = extractBodyContent(doc);
//             if (bodyContent != null && !bodyContent.isEmpty()) {
//                 content.append(bodyContent);
//             }
            
//             return content.toString();
//         } catch (Exception e) {
//             log.error("解析HTML内容时发生错误: {}", e.getMessage(), e);
//             return "解析网页内容时发生错误: " + e.getMessage();
//         }
//     }
    
//     /**
//      * 提取网页标题
//      * @param doc Jsoup文档对象
//      * @return 网页标题
//      */
//     private String extractTitle(Document doc) {
//         // 按优先级尝试不同的选择器
//         for (String selector : TITLE_SELECTORS) {
//             Elements elements = doc.select(selector);
//             if (!elements.isEmpty()) {
//                 Element element = elements.first();
//                 if (element != null) {
//                     String title = element.text().trim();
//                     if (!title.isEmpty()) {
//                         return title;
//                     }
//                 }
//             }
//         }
        
//         // 如果没找到，使用默认title标签
//         String title = doc.title();
//         return title != null ? title.trim() : "";
//     }
    
//     /**
//      * 提取网页正文内容
//      * @param doc Jsoup文档对象
//      * @return 正文内容
//      */
//     private String extractBodyContent(Document doc) {
//         StringBuilder content = new StringBuilder();
        
//         // 按优先级尝试不同的选择器
//         for (String selector : CONTENT_SELECTORS) {
//             Elements elements = doc.select(selector);
//             if (!elements.isEmpty()) {
//                 for (Element element : elements) {
//                     String text = extractTextFromElement(element);
//                     if (text != null && !text.isEmpty()) {
//                         content.append(text).append("\n\n");
//                     }
//                 }
                
//                 // 如果找到了内容就返回
//                 if (content.length() > 0) {
//                     return content.toString().trim();
//                 }
//             }
//         }
        
//         // 如果没有找到特定的内容区域，尝试从body中提取
//         Element body = doc.body();
//         if (body != null) {
//             String text = extractTextFromElement(body);
//             if (text != null && !text.isEmpty()) {
//                 return text.trim();
//             }
//         }
        
//         return "";
//     }
    
//     /**
//      * 从元素中提取纯文本内容
//      * @param element Jsoup元素对象
//      * @return 纯文本内容
//      */
//     private String extractTextFromElement(Element element) {
//         if (element == null) {
//             return "";
//         }
        
//         StringBuilder text = new StringBuilder();
        
//         // 获取所有子元素
//         Elements children = element.children();
//         for (Element child : children) {
//             // 跳过广告、导航等无关元素
//             if (shouldSkipElement(child)) {
//                 continue;
//             }
            
//             String tagName = child.tagName().toLowerCase();
            
//             // 处理标题元素
//             if (Pattern.matches("h[1-6]", tagName)) {
//                 String headingText = child.text().trim();
//                 if (!headingText.isEmpty()) {
//                     text.append("\n\n## ").append(headingText).append("\n\n");
//                 }
//             }
//             // 处理段落元素
//             else if ("p".equals(tagName)) {
//                 String paragraphText = child.text().trim();
//                 if (!paragraphText.isEmpty()) {
//                     text.append(paragraphText).append("\n\n");
//                 }
//             }
//             // 处理列表元素
//             else if ("ul".equals(tagName) || "ol".equals(tagName)) {
//                 Elements items = child.select("li");
//                 for (Element item : items) {
//                     String itemText = item.text().trim();
//                     if (!itemText.isEmpty()) {
//                         text.append("- ").append(itemText).append("\n");
//                     }
//                 }
//                 text.append("\n");
//             }
//             // 处理其他块级元素
//             else if (isBlockElement(tagName)) {
//                 String elementText = child.text().trim();
//                 if (!elementText.isEmpty()) {
//                     text.append(elementText).append("\n\n");
//                 }
//             }
//             // 递归处理内联元素
//             else {
//                 String childText = extractTextFromElement(child);
//                 if (!childText.isEmpty()) {
//                     text.append(childText);
//                 }
//             }
//         }
        
//         // 添加直接文本节点
//         String ownText = element.ownText().trim();
//         if (!ownText.isEmpty()) {
//             text.append(ownText).append(" ");
//         }
        
//         return text.toString().trim();
//     }
    
//     /**
//      * 判断是否应该跳过某个元素
//      * @param element Jsoup元素对象
//      * @return 是否应该跳过
//      */
//     private boolean shouldSkipElement(Element element) {
//         String className = element.className().toLowerCase();
//         String id = element.id().toLowerCase();
//         String tagName = element.tagName().toLowerCase();
        
//         // 跳过常见的无关元素
//         if ("nav".equals(tagName) || "header".equals(tagName) || "footer".equals(tagName) || 
//             "aside".equals(tagName) || "script".equals(tagName) || "style".equals(tagName)) {
//             return true;
//         }
        
//         // 跳过包含特定关键词的元素
//         String skipKeywords = "ad|ads|advertisement|banner|sidebar|menu|navigation|comment|share|social";
//         if (className.matches(".*(" + skipKeywords + ").*") || 
//             id.matches(".*(" + skipKeywords + ").*")) {
//             return true;
//         }
        
//         return false;
//     }
    
//     /**
//      * 判断是否为块级元素
//      * @param tagName 标签名
//      * @return 是否为块级元素
//      */
//     private boolean isBlockElement(String tagName) {
//         String blockElements = "div|section|article|main|blockquote|pre|table|form|fieldset";
//         return Pattern.matches(blockElements, tagName);
//     }
    
//     /**
//      * 记录到工作面板（不带执行时间）
//      */
//     private void recordToWorkPanel(String toolAction, Object input, Object output, String status) {
//         recordToWorkPanel(toolAction, input, output, status, null);
//     }
    
//     /**
//      * 记录到工作面板（带执行时间）
//      */
//     private void recordToWorkPanel(String toolAction, Object input, Object output, String status, Long executionTime) {
//         try {
//             // 首先尝试从Spring容器获取collector
//             IWorkPanelDataCollector collector = null;
//             if (applicationContext != null) {
//                 try {
//                     collector = applicationContext.getBean(IWorkPanelDataCollector.class);
//                 } catch (Exception e) {
//                     log.debug("通过Spring容器获取WorkPanelDataCollector失败: {}", e.getMessage());
//                 }
//             }
            
//             if (collector != null) {
//                 // 记录工具调用
//                 if (input != null && status == null) {
//                     // 调用开始
//                     collector.recordToolCallStart("网页内容提取工具", toolAction, input);
//                 } else if (input == null && status != null) {
//                     // 调用结束（input为null表示这是结束调用）
//                     collector.recordToolCallComplete("网页内容提取工具", output, status, executionTime);
//                 } else if (input != null && status != null) {
//                     // 调用结束（input不为null，status不为null表示这是结束调用）
//                     collector.recordToolCallComplete("网页内容提取工具", output, status, executionTime);
//                 }
//             } else {
//                 log.debug("无法记录到工作面板：collector为null");
//             }
//         } catch (Exception e) {
//             log.debug("记录工作面板失败", e);
//         }
//     }
    
//     /**
//      * 发送embed事件到工作面板
//      * @param url 网页URL
//      * @param type MIME类型
//      * @param title embed标题
//      * @param content 提取的内容
//      */
//     private void sendEmbedEvent(String url, String type, String title, String content) {
//         try {
//             // 从Spring容器获取collector
//             IWorkPanelDataCollector collector = null;
//             if (applicationContext != null) {
//                 try {
//                     collector = applicationContext.getBean(IWorkPanelDataCollector.class);
//                     log.debug("通过Spring容器获取到WorkPanelDataCollector实例");
//                 } catch (Exception e) {
//                     log.debug("通过Spring容器获取WorkPanelDataCollector失败: {}", e.getMessage());
//                 }
//             }
            
//             if (collector != null) {
//                 // 使用新的recordEmbed方法发送embed事件
//                 collector.recordEmbed(url, type, title, content);
//                 log.debug("已发送embed事件到工作面板: title={}, type={}, hasContent={}", 
//                     title, type, content != null && !content.isEmpty());
//             } else {
//                 log.warn("无法发送embed事件：collector为null，无法从Spring容器获取");
//             }
//         } catch (Exception e) {
//             log.error("发送embed事件失败: {}", e.getMessage(), e);
//         }
//     }
// }