import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import path from 'path'

export default defineConfig({
  plugins: [vue()],
  resolve: {
    alias: {
      '@': path.resolve(__dirname, './src')
    }
  },
  server: {
    port: 5174,
    strictPort: true, // 确保总是使用指定端口
    // 添加headers配置以允许iframe加载
    headers: {
      'X-Frame-Options': 'SAMEORIGIN'
    },
    proxy: {
      '/api': {
        target: 'http://localhost:8080',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, '/api')
      },
      '/ws': {
        target: 'http://localhost:8080',
        ws: true, // 启用WebSocket代理
        changeOrigin: true
      }
    }
  },
  build: {
    target: 'esnext',
    minify: 'terser',
    sourcemap: false
  },
  esbuild: {
    jsxFactory: 'h',
    jsxFragment: 'Fragment',
    tsconfigRaw: '{}'
  }
})