# HiAgent - 智能AI助手

HiAgent 是一个功能强大的个人AI助手，集成了多种工具和服务，能够帮助用户完成各种任务。

## 🌟 核心功能

### 网页访问和内容提取
- **网页访问工具**：能够根据网站名称或URL访问网页并在工作面板中预览
- **网页内容提取工具**：智能提取网页正文内容，自动识别并提取文章标题和主要内容，过滤掉广告、导航栏等无关内容
- **增强型网页嵌入预览**：支持多种加载策略（直接HTML、直接获取内容、iframe），自动处理X-Frame-Options等安全限制

### 计算和数据处理
- **计算器工具**：执行基本数学运算和复杂数学计算
- **日期时间工具**：获取当前时间、日期计算等
- **文件处理工具**：文件上传、下载和处理
- **字符串处理工具**：文本处理和转换功能

### 其他实用工具
- **天气查询工具**：获取指定城市的天气信息
- **OAuth2.0授权工具**：支持通过用户名和密码凭证获取网页资源访问授权，实现标准OAuth2.0认证流程

## 🛠 技术架构

### 后端技术栈
- **Spring Boot 3.3.4**：基于Java 17的现代化Web框架
- **Spring AI**：集成多种AI模型和服务
- **MySQL/H2**：数据存储
- **Redis**：缓存和会话管理
- **Milvus**：向量数据库支持
- **RabbitMQ**：消息队列服务

### 前端技术栈
- **Vue 3**：现代化的前端框架
- **TypeScript**：类型安全的JavaScript超集
- **Vite**：快速的构建工具

## 📦 主要工具介绍

### 网页内容提取工具 (WebContentExtractorTool)

这是一个专门用于从网页中提取有意义文本内容的工具。它能够自动识别并提取网页的标题和正文内容，同时过滤掉广告、导航栏等无关内容。

#### 功能特点
1. **智能内容提取**：自动识别网页的主要内容区域
2. **广告过滤**：自动过滤广告、导航栏等无关内容
3. **格式保留**：保留原文的标题层级和段落结构
4. **错误处理**：完善的错误处理机制和日志记录

#### 使用方法
在Agent对话中直接调用：
```
extractWebContent("https://example.com/article")
```

### 网页访问工具 (WebPageAccessTools)

提供根据网站名称或URL地址访问网页并在工作面板中预览的功能。

#### 功能特点
1. **多种访问方式**：支持按网站名称或直接URL访问
2. **内置网站映射**：支持常见网站的快捷访问
3. **工作面板集成**：直接在工作面板中预览网页内容
4. **多种加载策略**：支持HTML内容、直接获取内容和iframe三种加载方式
5. **智能错误处理**：自动处理X-Frame-Options等安全限制，提供友好的错误提示

#### 使用方法
```
accessWebSiteByName("百度")
accessWebSiteByUrl("https://www.example.com")
```

### 增强型网页嵌入预览 (EmbedPreview)

提供增强的网页嵌入预览功能，支持多种加载策略以应对不同的安全限制。

#### 功能特点
1. **多种加载策略**：
   - **HTML内容**：直接渲染后端提供的HTML内容
   - **直接获取**：通过代理API获取网页内容并直接渲染（绕过X-Frame-Options限制）
   - **iframe加载**：传统的iframe嵌入方式（备选方案）
2. **智能回退机制**：当一种策略失败时自动尝试其他策略
3. **安全处理**：使用DOMPurify清理内容，防止XSS攻击
4. **错误处理**：完善的错误处理和用户友好的错误提示
5. **响应式设计**：适配不同屏幕尺寸

#### 使用方法
```vue
<EmbedPreview 
  :html-content="htmlContent"
  :embed-url="url"
  embed-title="预览标题"
  embed-type="网页"
/>
```

### OAuth2.0授权工具 (OAuth2AuthorizationTool)

这是一个支持OAuth2.0标准认证流程的工具，允许用户通过用户名和密码凭证获取访问受保护资源的令牌。

#### 功能特点
1. **标准OAuth2.0支持**：完全符合OAuth2.0 RFC标准
2. **密码凭证流**：支持Resource Owner Password Credentials Grant流程
3. **令牌管理**：自动管理和缓存访问令牌
4. **令牌刷新**：支持使用刷新令牌获取新的访问令牌
5. **安全存储**：令牌安全存储，自动处理过期令牌
6. **资源访问**：使用获取的令牌访问受保护的资源

#### 使用方法
```
// 1. 获取访问令牌
authorizeWithPasswordCredentials(
  "https://example.com/oauth/token", 
  "your-client-id", 
  "your-client-secret", 
  "your-username", 
  "your-password", 
  "read write"
)

// 2. 刷新访问令牌
refreshToken(
  "https://example.com/oauth/token", 
  "your-client-id", 
  "your-client-secret", 
  "your-refresh-token"
)

// 3. 访问受保护资源
accessProtectedResource(
  "https://example.com/api/protected", 
  "https://example.com/oauth/token", 
  "your-client-id"
)
```

有关更详细的使用说明，请参阅 [OAuth2.0工具使用指南](OAUTH2_TOOL_USAGE_GUIDE.md)

## 🚀 快速开始

### 环境要求
- Java 17+
- Node.js 16+
- Maven 3.8+
- MySQL 8.0+ (可选，也可使用内置H2数据库)

### 后端启动
```bash
cd backend
mvn spring-boot:run
```

### 前端启动
```bash
cd frontend
npm install
npm run dev
```

### 一键启动脚本
- Windows: `run-all-debug.bat`
- 后端独立: `run-backend-debug.bat`
- 前端独立: `run-frontend-debug.bat`

## 📁 项目结构

```
HiAgent/
├── backend/              # 后端服务
│   ├── src/
│   │   ├── main/
│   │   │   ├── java/     # Java源代码
│   │   │   └── resources/ # 配置文件和静态资源
│   │   └── test/         # 测试代码
│   └── pom.xml           # Maven配置文件
├── frontend/             # 前端应用
│   ├── src/              # Vue源代码
│   ├── public/           # 静态资源
│   └── package.json      # NPM配置文件
├── docker-compose.yml    # Docker编排文件
└── README.md            # 项目说明文件
```

## 🔧 配置说明

### 数据库配置
项目支持MySQL和H2数据库，默认使用H2内存数据库，可通过修改`application.yml`配置切换。

### AI模型配置
支持多种AI模型：
- OpenAI/DeepSeek
- Ollama本地模型
- 其他兼容OpenAI API的模型

## 🧪 测试

### 后端测试
```bash
cd backend
mvn test
```

### 前端测试
```bash
cd frontend
npm run test
```

## 🐳 Docker部署

使用docker-compose一键部署：
```bash
docker-compose up -d
```

## 📚 文档

项目包含丰富的技术文档：
- 工具使用说明
- 架构设计文档
- 部署指南
- 故障排查手册

## 🤝 贡献

欢迎提交Issue和Pull Request来改进项目。

## 📄 许可证

本项目采用MIT许可证。

## 🙏 致谢

感谢所有开源项目的贡献者们，以及支持这个项目开发的用户。