# HiAgent 问题修复指南

## 问题分析

从终端日志中发现两个主要问题：

1. **LLM配置验证失败**：`java.lang.IllegalArgumentException: LLM配置验证失败: deepseek`
2. **Spring Security访问被拒绝**：`AuthorizationDeniedException: Access Denied`

## 根本原因

### LLM配置问题
[data.sql](file:///c:/Users/Gavin/Documents/PangeaFinal/HiAgent/backend/src/main/resources/data.sql)中的deepseek配置API密钥为空，而[DeepSeekModelAdapter.java](file:///c:/Users/Gavin/Documents/PangeaFinal/HiAgent/backend/src/main/java/pangea/hiagent/llm/DeepSeekModelAdapter.java)的验证逻辑要求必须有非空的API密钥。

### 安全配置问题
缺少必要的环境变量，包括`DEEPSEEK_API_KEY`和`JWT_SECRET`。

## 解决方案

### 方案一：使用环境变量（推荐）

1. 编辑[run-with-env.bat](file:///c:/Users/Gavin/Documents/PangeaFinal/HiAgent/run-with-env.bat)文件，将占位符替换为实际值：
   ```batch
   set DEEPSEEK_API_KEY=sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  # 替换为你的DeepSeek API密钥
   set JWT_SECRET=your-secure-jwt-secret-key  # 替换为你自己的JWT密钥
   ```

2. 运行[run-with-env.bat](file:///c:/Users/Gavin/Documents/PangeaFinal/HiAgent/run-with-env.bat)启动应用：
   ```bash
   run-with-env.bat
   ```

### 方案二：临时修复（仅用于测试）

如果你只是想快速测试应用而不关心安全性，可以：

1. 修改[LlmConfigService.java](file:///c:/Users/Gavin/Documents/PangeaFinal/HiAgent/backend/src/main/java/pangea/hiagent/service/LlmConfigService.java)中的验证逻辑，允许空API密钥：
   ```java
   // 在DeepSeekModelAdapter.java中修改validateConfig方法
   @Override
   public boolean validateConfig(LlmConfig config) {
       return config != null &&
           config.getEnabled(); 
           // 移除了对API密钥非空的检查
   }
   ```

注意：这种方法仅适用于测试环境，生产环境中必须配置有效的API密钥。

## 登录凭证

默认登录账户：
- 用户名：`admin`
- 密码：`admin123` （如果使用的是开发环境默认密码）

## 验证修复

启动应用后，可以通过以下方式验证修复是否成功：

1. 访问 http://localhost:8080 并使用默认账户登录
2. 进入Agent管理页面，确认Agent可以正常加载
3. 尝试与Agent进行对话，确认不再出现"LLM配置验证失败"错误

## 故障排除

如果仍然遇到问题，请检查：

1. 确认环境变量已正确设置
2. 确认数据库已正确初始化
3. 查看应用启动日志中是否有其他错误信息
4. 确认网络连接正常，可以访问DeepSeek API