package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 定时器执行历史实体类
 */
@Data
@TableName("hiagent_timer_execution_history")
public class TimerExecutionHistory {

    /**
     * 主键ID，使用数据库自增策略
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 关联的定时器ID
     */
    @TableField("timer_id")
    private String timerId;

    /**
     * 定时器名称
     */
    @TableField("timer_name")
    private String timerName;

    /**
     * 执行时间
     */
    @TableField("execution_time")
    private LocalDateTime executionTime;

    /**
     * 执行结果（0-失败，1-成功）
     */
    @TableField("success")
    private Integer success;

    /**
     * 执行结果详情
     */
    @TableField("result")
    private String result;

    /**
     * 错误信息
     */
    @TableField("error_message")
    private String errorMessage;

    /**
     * 执行时长（毫秒）
     */
    @TableField("execution_duration")
    private Long executionDuration;

    /**
     * 实际执行的提示词
     */
    @TableField("actual_prompt")
    private String actualPrompt;

    /**
     * 创建时间
     */
    @TableField("created_at")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @TableField("updated_at")
    private LocalDateTime updatedAt;

    /**
     * 创建人
     */
    @TableField("created_by")
    private String createdBy;

    /**
     * 更新人
     */
    @TableField("updated_by")
    private String updatedBy;

    /**
     * 删除标记（0-未删除，1-已删除）
     */
    @TableLogic
    @TableField("deleted")
    private Integer deleted;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
}
