package pangea.hiagent.config;

import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * Web相关配置类
 * 配置Web相关的Bean，如RestTemplate等
 */
@Configuration
public class WebConfig {
    
    /**
     * 配置RestTemplate Bean
     * 用于发送HTTP请求
     * 增强配置：设置连接和读取超时
     */
    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder
                .connectTimeout(java.time.Duration.ofSeconds(10))
                .readTimeout(java.time.Duration.ofSeconds(10))
                .build();
    }
}