package pangea.hiagent.web.service;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import pangea.hiagent.tool.impl.HisenseTripTool;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Service
@Slf4j
public class InfoCollectorService {
    private static final ConcurrentHashMap<String, JSONArray> infos = new ConcurrentHashMap<>(16);
    private static final ConcurrentHashMap<String, Object> values = new ConcurrentHashMap<>(16);

    public void register(String pageId, JSONArray info) {
        infos.put(pageId, info);
    }

    public boolean exists(String pageId) {
        return infos.containsKey(pageId);
    }

    public JSONArray getInfo(String pageId) {
        return infos.get(pageId);
    }

    public void saveValue(String key, Object value) {
        log.info("key {} value {}",key,value);
        values.put(key, value);
    }

    public Object getValue(String key) {
        return values.get(key);
    }

    public Set<String> findLackInfo() {
        Set<String> valueKeys = values.keySet();
        Set<String> allKeys = infos.get(HisenseTripTool.pageId).stream().map(t -> ((JSONObject) t).getString("field_name")).collect(Collectors.toSet());
        allKeys.removeAll(valueKeys);
        log.info("lack keys {}", allKeys);
        return allKeys;
    }
}
