package pangea.hiagent.web.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.Map;

/**
 * 工具事件数据传输对象
 * 用于表示工具调用相关的所有事件（调用、结果、错误）
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class ToolEvent extends WorkPanelEvent {
    private static final long serialVersionUID = 1L;
    
    /**
     * 工具名称
     */
    private String toolName;
    
    /**
     * 工具执行的方法/action
     */
    private String toolAction;
    
    /**
     * 工具输入参数
     */
    private Map<String, Object> toolInput;
    
    /**
     * 工具输出结果
     */
    private Object toolOutput;
    
    /**
     * 工具执行状态（pending/success/failure/error）
     */
    private String toolStatus;
    
    /**
     * 执行耗时（毫秒）
     */
    private Long executionTime;
    
    /**
     * 错误信息
     */
    private String errorMessage;
    
    /**
     * 错误代码
     */
    private String errorCode;
}