package pangea.hiagent.utils;

import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;

import static org.junit.jupiter.api.Assertions.assertNull;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertEquals;

@SpringBootTest
@TestPropertySource(locations = "classpath:application.yml")
public class UserUtilsTest {

    @Test
    public void testGetCurrentUserIdWhenNotAuthenticated() {
        // 在没有认证的情况下调用getCurrentUserId()，应该返回null
        String userId = UserUtils.getCurrentUserId();
        assertNull(userId, "未认证时用户ID应为null");
    }

    @Test
    public void testIsAuthenticatedWhenNotAuthenticated() {
        // 在没有认证的情况下调用isAuthenticated()，应该返回false
        boolean authenticated = UserUtils.isAuthenticated();
        assert !authenticated : "未认证时isAuthenticated()应返回false";
    }

    @Test
    public void testGetCurrentUserIdNotNullWhenAuthenticated() {
        // 在有认证的情况下调用getCurrentUserId()，应该返回非null值
        // 注意：此测试需要在有有效认证的上下文中运行才能通过
        // 这里只是展示测试结构
        // String userId = UserUtils.getCurrentUserId();
        // assertNotNull(userId, "认证时用户ID不应为null");
    }
    
    @Test
    public void testGetCurrentUserIdInAsync() {
        // 测试在异步环境中获取用户ID的方法
        String userId = UserUtils.getCurrentUserIdInAsync();
        // 在没有认证的情况下，应该返回null
        assertNull(userId, "未认证时在异步环境中用户ID应为null");
    }
}