@echo off
REM HiAgent 前端Debug启动脚本
REM 此脚本用于启动Vue3开发服务器进行调试

setlocal enabledelayedexpansion

echo.
echo ========================================
echo   HiAgent 前端Debug调试启动
echo ========================================
echo.

REM 检查Node.js是否安装
node --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] 未找到Node.js安装，请确保Node.js 18+已安装
    pause
    exit /b 1
)

REM 进入前端目录
cd /d "%~dp0frontend"

echo [INFO] 检查依赖...
if not exist "node_modules" (
    echo [INFO] 首次运行，安装依赖...
    call npm install
    if errorlevel 1 (
        echo [ERROR] 依赖安装失败
        pause
        exit /b 1
    )
)

echo [INFO] 启动开发服务器（Debug模式）...
echo [INFO] 访问地址: http://localhost:5173
echo [INFO] 后端API地址: http://localhost:8080
echo [INFO] 在浏览器中按 F12 打开开发者工具进行调试
echo.

REM 启动开发服务器
call npm run dev

pause
