-- HiAgent数据库初始化脚本

USE hiagent;

-- 用户表
CREATE TABLE IF NOT EXISTS `sys_user` (
  `id` varchar(36) NOT NULL,
  `username` varchar(50) NOT NULL UNIQUE,
  `password` varchar(255) NOT NULL,
  `email` varchar(100),
  `nickname` varchar(100),
  `status` varchar(20) DEFAULT 'active',
  `role` varchar(50) DEFAULT 'user',
  `avatar` varchar(255),
  `last_login_time` bigint,
  `api_key` varchar(255),
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`),
  KEY `idx_username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Agent表
CREATE TABLE IF NOT EXISTS `agent` (
  `id` varchar(36) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text,
  `status` varchar(20) DEFAULT 'active',
  `default_model` varchar(50),
  `system_prompt` text,
  `prompt_template` text,
  `temperature` decimal(3,2) DEFAULT 0.7,
  `max_tokens` int DEFAULT 4096,
  `top_p` decimal(3,2) DEFAULT 0.9,
  `top_k` int DEFAULT 50,
  `presence_penalty` decimal(3,2) DEFAULT 0,
  `frequency_penalty` decimal(3,2) DEFAULT 0,
  `history_length` int DEFAULT 10,
  `tools` json,
  `rag_collection_id` varchar(36),
  `enable_rag` tinyint DEFAULT 0,
  `enable_react` tinyint DEFAULT 0,
  `owner` varchar(36),
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`),
  KEY `idx_owner` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 工具表
CREATE TABLE IF NOT EXISTS `tool` (
  `id` varchar(36) NOT NULL,
  `name` varchar(100) NOT NULL,
  `display_name` varchar(100),
  `description` text,
  `category` varchar(50),
  `status` varchar(20) DEFAULT 'active',
  `parameters` json,
  `return_type` varchar(50),
  `return_schema` json,
  `implementation` text,
  `timeout` bigint,
  `api_endpoint` varchar(255),
  `http_method` varchar(20),
  `owner` varchar(36),
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 文档表
CREATE TABLE IF NOT EXISTS `document` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(20),
  `size` bigint,
  `status` varchar(20) DEFAULT 'uploading',
  `chunks` int DEFAULT 0,
  `collection_id` varchar(36),
  `file_path` varchar(255),
  `author` varchar(100),
  `source` varchar(100),
  `tags` json,
  `metadata` json,
  `embedding_model` varchar(100),
  `error_message` text,
  `owner` varchar(36),
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 文档片段表
CREATE TABLE IF NOT EXISTS `document_chunk` (
  `id` varchar(36) NOT NULL,
  `document_id` varchar(36) NOT NULL,
  `content` longtext,
  `page_number` int,
  `score` decimal(3,2),
  `sequence` int,
  `vector_id` bigint,
  `metadata` json,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`),
  KEY `idx_document_id` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Agent对话表
CREATE TABLE IF NOT EXISTS `agent_dialogue` (
  `id` varchar(36) NOT NULL,
  `agent_id` varchar(36) NOT NULL,
  `context_id` varchar(36),
  `user_message` longtext,
  `agent_response` longtext,
  `prompt_tokens` int,
  `completion_tokens` int,
  `total_tokens` int,
  `processing_time` bigint,
  `finish_reason` varchar(50),
  `tool_calls` json,
  `user_id` varchar(36),
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`),
  KEY `idx_agent_id` (`agent_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 系统日志表
CREATE TABLE IF NOT EXISTS `sys_log` (
  `id` varchar(36) NOT NULL,
  `operation_type` varchar(50),
  `resource_type` varchar(50),
  `resource_id` varchar(36),
  `user_id` varchar(36),
  `description` text,
  `request_params` json,
  `response_result` json,
  `success` tinyint DEFAULT 1,
  `error_message` text,
  `ip_address` varchar(50),
  `execution_time` bigint,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(36),
  `updated_by` varchar(36),
  `deleted` int DEFAULT 0,
  `remark` text,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 插入默认数据
INSERT INTO `sys_user` (id, username, password, email, nickname, status, role) VALUES 
('default-user-id', 'admin', '$2a$10$N.zmdr9k7uOCQb0bta/OauRxaOKSr.QhqyD2R5FKvMQjmHoLkm5Sy', 'admin@hiagent.com', 'Admin', 'active', 'admin');

INSERT INTO `agent` (id, name, description, status, default_model, owner) VALUES 
('default-agent-1', '客服助手', '处理客户咨询的AI助手', 'active', 'deepseek-v2', 'default-user-id'),
('default-agent-2', '技术支持', '提供技术支持服务的AI助手', 'active', 'gpt-3.5-turbo', 'default-user-id');

INSERT INTO `tool` (id, name, display_name, description, category, status, timeout, http_method) VALUES 
('default-tool-1', 'search', '搜索工具', '进行网络搜索查询', 'API', 'active', 30000, 'GET'),
('default-tool-2', 'calculator', '计算器', '进行数学计算', 'FUNCTION', 'active', 5000, 'POST'),
('default-tool-3', 'weather', '天气查询', '查询天气信息', 'API', 'active', 10000, 'GET'),
('default-tool-4', 'get_current_time', '获取当前时间', '获取当前系统时间', 'FUNCTION', 'active', 1000, 'GET');
