package pangea.hiagent.controller;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pangea.hiagent.dto.ApiResponse;
import pangea.hiagent.model.LlmConfig;
import pangea.hiagent.repository.LlmConfigRepository;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/api/v1/test")
public class TestController {
    
    private final LlmConfigRepository llmConfigRepository;
    
    public TestController(LlmConfigRepository llmConfigRepository) {
        this.llmConfigRepository = llmConfigRepository;
    }
    
    @GetMapping("/llm-configs")
    public ApiResponse<List<LlmConfig>> getAllLlmConfigs() {
        try {
            List<LlmConfig> configs = llmConfigRepository.selectList(null);
            log.info("查询到 {} 条LLM配置", configs.size());
            for (LlmConfig config : configs) {
                log.info("配置: ID={}, 名称={}, 模型名={}, 提供商={}, 启用状态={}", 
                    config.getId(), config.getName(), config.getModelName(), 
                    config.getProvider(), config.getEnabled());
            }
            return ApiResponse.success(configs);
        } catch (Exception e) {
            log.error("查询LLM配置失败", e);
            return ApiResponse.error(5001, "查询LLM配置失败: " + e.getMessage());
        }
    }
    
    @GetMapping("/hisense-config")
    public ApiResponse<LlmConfig> getHisenseConfig() {
        try {
            LambdaQueryWrapper<LlmConfig> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(LlmConfig::getModelName, "hisense-default");
            wrapper.eq(LlmConfig::getEnabled, true);
            LlmConfig config = llmConfigRepository.selectOne(wrapper);
            
            if (config != null) {
                log.info("找到海信配置: ID={}, 名称={}, 模型名={}, 提供商={}, 启用状态={}", 
                    config.getId(), config.getName(), config.getModelName(), 
                    config.getProvider(), config.getEnabled());
                return ApiResponse.success(config);
            } else {
                log.warn("未找到启用的海信配置");
                // 尝试查找所有海信配置
                LambdaQueryWrapper<LlmConfig> allWrapper = new LambdaQueryWrapper<>();
                allWrapper.eq(LlmConfig::getModelName, "hisense-default");
                List<LlmConfig> allConfigs = llmConfigRepository.selectList(allWrapper);
                log.info("找到 {} 条海信配置", allConfigs.size());
                for (LlmConfig c : allConfigs) {
                    log.info("海信配置详情: ID={}, 名称={}, 模型名={}, 提供商={}, 启用状态={}", 
                        c.getId(), c.getName(), c.getModelName(), 
                        c.getProvider(), c.getEnabled());
                }
                return ApiResponse.error(4001, "未找到启用的海信配置");
            }
        } catch (Exception e) {
            log.error("查询海信配置失败", e);
            return ApiResponse.error(5001, "查询海信配置失败: " + e.getMessage());
        }
    }
}