package pangea.hiagent.agent.data;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 错误事件数据构建器
 * 专门负责构建错误事件数据
 */
@Component
public class ErrorEventDataBuilder {
    
    @Autowired
    private MapPoolService mapPoolService;
    
    /**
     * 创建错误事件数据
     *
     * @param errorMessage 错误信息
     * @return 错误事件数据
     */
    public Map<String, Object> createErrorEventData(String errorMessage) {
        Map<String, Object> data = mapPoolService.acquireMap();
        // 同时提供message和error字段，以确保前端兼容性
        data.put("message", errorMessage != null ? errorMessage : "未知错误");
        data.put("error", errorMessage != null ? errorMessage : "未知错误");
        data.put("timestamp", System.currentTimeMillis());
        data.put("type", "error");
        return data;
    }
}

