// 类型守卫函数

import type { 
  TimelineEvent, 
  ThoughtEvent, 
  ToolCallEvent, 
  ToolResultEvent, 
  ToolErrorEvent, 
  EmbedEvent 
} from '../types/timeline';

/**
 * 检查是否为思考事件
 * @param event 事件对象
 * @returns 是否为思考事件
 */
export function isThoughtEvent(event: TimelineEvent): event is ThoughtEvent {
  return event.type === 'thought';
}

/**
 * 检查是否为工具调用事件
 * @param event 事件对象
 * @returns 是否为工具调用事件
 */
export function isToolCallEvent(event: TimelineEvent): event is ToolCallEvent {
  return event.type === 'tool_call';
}

/**
 * 检查是否为工具结果事件
 * @param event 事件对象
 * @returns 是否为工具结果事件
 */
export function isToolResultEvent(event: TimelineEvent): event is ToolResultEvent {
  return event.type === 'tool_result';
}

/**
 * 检查是否为工具错误事件
 * @param event 事件对象
 * @returns 是否为工具错误事件
 */
export function isToolErrorEvent(event: TimelineEvent): event is ToolErrorEvent {
  return event.type === 'tool_error';
}

/**
 * 检查是否为嵌入事件
 * @param event 事件对象
 * @returns 是否为嵌入事件
 */
export function isEmbedEvent(event: TimelineEvent): event is EmbedEvent {
  return event.type === 'embed';
}