package pangea.hiagent.agent.data;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * 哈希计算器，用于校验数据完整性
 */
public class HashCalculator {
    
    private static final String ALGORITHM = "SHA-256";
    
    /**
     * 计算字符串的SHA-256哈希值
     */
    public static String calculateHash(String data) {
        if (data == null) {
            data = "";
        }
        
        try {
            MessageDigest digest = MessageDigest.getInstance(ALGORITHM);
            byte[] hashBytes = digest.digest(data.getBytes(StandardCharsets.UTF_8));
            
            // 将字节数组转换为十六进制字符串
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to calculate hash", e);
        }
    }
    
    /**
     * 计算对象的哈希值
     */
    public static String calculateHash(Object obj) {
        if (obj == null) {
            return calculateHash("");
        }
        
        String data = obj.toString();
        if (obj instanceof java.util.Map || obj instanceof java.util.Collection) {
            // 对于复杂对象，转换为JSON字符串再计算哈希
            data = obj.toString(); // 实际应用中可能需要更复杂的序列化逻辑
        }
        
        return calculateHash(data);
    }
}