package pangea.hiagent.agent.data;

import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 任务依赖解析器
 */
@Component
public class TaskDependencyResolver {
    /**
     * 解析子任务依赖关系，生成执行批次
     * 同批次任务可并行执行，跨批次任务串行执行
     */
    public List<List<SubTask>> resolve(List<SubTask> subTasks) {
        List<List<SubTask>> batches = new ArrayList<>();
        Set<String> completedTaskIds = new HashSet<>();

        // 初始批次：无依赖的子任务
        List<SubTask> firstBatch = subTasks.stream()
                .filter(t -> t.getDependOn().isEmpty())
                .collect(Collectors.toList());
        batches.add(firstBatch);
        completedTaskIds.addAll(firstBatch.stream().map(SubTask::getSubTaskId).collect(Collectors.toList()));

        // 递归解析后续批次
        while (completedTaskIds.size() < subTasks.size()) {
            List<SubTask> nextBatch = subTasks.stream()
                    .filter(t -> !completedTaskIds.contains(t.getSubTaskId()))
                    .filter(t -> completedTaskIds.containsAll(t.getDependOn()))
                    .collect(Collectors.toList());
            if (nextBatch.isEmpty()) {
                throw new IllegalStateException("Circular dependency detected in subtasks");
            }
            batches.add(nextBatch);
            completedTaskIds.addAll(nextBatch.stream().map(SubTask::getSubTaskId).collect(Collectors.toList()));
        }
        return batches;
    }
}