package pangea.hiagent.agent.data;

import lombok.Data;
import java.util.Map;
import java.util.UUID;

/**
 * 协同命令数据结构
 * 用于Agent间的通信和任务协调
 */
@Data
public class CooperateCommand {
    /** 全局唯一消息ID，用于幂等校验 */
    private String messageId;
    /** 关联主任务ID */
    private String taskId;
    /** 发送方Agent ID */
    private String senderAgentId;
    /** 接收方Agent ID */
    private String receiverAgentId;
    /** 动作类型：TASK_ASSIGN/RESULT_REPORT/FAIL_RETRY */
    private String action;
    /** 业务参数体 */
    private Map<String, Object> params;
    /** 结果校验哈希值 */
    private String resultHash;

    public CooperateCommand() {
        this.messageId = UUID.randomUUID().toString();
    }
}